/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

class FurnMenuBar
extends JMenuBar {
    private JFrame frame;
    private LeftPanel leftPanel;
    private RightPanel rightPanel;
    private JFileChooser fileChooser;
    static final String instrPage = "instructions.html";
    static final String optionFileName = "options.dat";
    static final String aboutMessage = "Furniture Mover 0.3\nby Leif Rem\u00f8\nNovember 2001";
    protected Color leftBackColor;
    protected Color rightBackColor;
    protected boolean showNames = true;

    public FurnMenuBar(final JFrame jFrame, JLabel jLabel, LeftPanel leftPanel, RightPanel rightPanel) {
        Object object;
        Object object2;
        Object object3;
        this.leftPanel = leftPanel;
        this.rightPanel = rightPanel;
        this.frame = jFrame;
        this.fileChooser = new JFileChooser();
        FurnFileFilter furnFileFilter = new FurnFileFilter();
        this.fileChooser.setFileFilter(furnFileFilter);
        this.fileChooser.setFileSelectionMode(1);
        try {
            object3 = new FileInputStream(optionFileName);
            object2 = new InputStreamReader((InputStream)object3);
            object = new BufferedReader((Reader)object2);
            String string = ((BufferedReader)object).readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            this.showNames = Boolean.valueOf(stringTokenizer.nextToken());
            this.rightPanel.getMainPanel().setVisibleNames(this.showNames);
            this.fileChooser.setCurrentDirectory(new File(stringTokenizer.nextToken()));
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            this.leftBackColor = new Color(n, n2, n3);
            this.leftPanel.getItemPanel().setBackColor(this.leftBackColor);
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            this.rightBackColor = new Color(n, n2, n3);
            this.rightPanel.getMainPanel().setBackColor(this.rightBackColor);
            ((FileInputStream)object3).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = new JMenu("File");
        ((AbstractButton)object3).setMnemonic(70);
        object2 = null;
        object2 = new JMenuItem("New");
        ((AbstractButton)object2).setMnemonic(78);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FurnMenuBar.this.leftPanel.getItemPanel().reset();
                FurnMenuBar.this.rightPanel.getMainPanel().reset();
            }
        });
        ((JMenu)object3).add((JMenuItem)object2);
        object2 = new JMenuItem("Open");
        ((AbstractButton)object2).setMnemonic(79);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FurnMenuBar.this.openFile();
            }
        });
        ((JMenu)object3).add((JMenuItem)object2);
        object2 = new JMenuItem("Save");
        ((AbstractButton)object2).setMnemonic(83);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FurnMenuBar.this.saveToFile();
            }
        });
        ((JMenu)object3).add((JMenuItem)object2);
        ((JMenu)object3).addSeparator();
        object2 = new JMenuItem("Options");
        ((AbstractButton)object2).setMnemonic(80);
        object = new OptionDialog((Frame)jFrame, this);
        ((AbstractButton)object2).addActionListener(new ActionListener((OptionDialog)object){
            private final /* synthetic */ OptionDialog val$optionDialog;
            {
                this.val$optionDialog = optionDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$optionDialog.pack();
                ((Component)this.val$optionDialog).setVisible(true);
                if (this.val$optionDialog.isOK()) {
                    try {
                        PrintWriter printWriter = new PrintWriter(new FileWriter(FurnMenuBar.optionFileName));
                        printWriter.print(FurnMenuBar.this.showNames);
                        if (FurnMenuBar.this.fileChooser.getSelectedFile() != null) {
                            FurnMenuBar.this.fileChooser.setCurrentDirectory(new File(FurnMenuBar.this.fileChooser.getSelectedFile().getCanonicalPath()));
                        }
                        printWriter.print("\t" + FurnMenuBar.this.fileChooser.getCurrentDirectory().getCanonicalPath());
                        printWriter.println("\t" + FurnMenuBar.this.leftBackColor.getRed() + "\t" + FurnMenuBar.this.leftBackColor.getGreen() + "\t" + FurnMenuBar.this.leftBackColor.getBlue() + "\t" + FurnMenuBar.this.rightBackColor.getRed() + "\t" + FurnMenuBar.this.rightBackColor.getGreen() + "\t" + FurnMenuBar.this.rightBackColor.getBlue());
                        printWriter.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FurnMenuBar.this.rightPanel.getMainPanel().setVisibleNames(FurnMenuBar.this.showNames);
                    FurnMenuBar.this.leftPanel.getItemPanel().setBackColor(FurnMenuBar.this.leftBackColor);
                    FurnMenuBar.this.rightPanel.getMainPanel().setBackColor(FurnMenuBar.this.rightBackColor);
                }
            }
        });
        ((JMenu)object3).add((JMenuItem)object2);
        ((JMenu)object3).addSeparator();
        object2 = new JMenuItem("Exit");
        ((AbstractButton)object2).setMnemonic(88);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        ((JMenu)object3).add((JMenuItem)object2);
        this.add((JMenu)object3);
        object3 = new JMenu("Help");
        ((AbstractButton)object3).setMnemonic(72);
        object2 = new JMenuItem("Instructions");
        ((AbstractButton)object2).setMnemonic(73);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.setEditable(false);
                try {
                    jEditorPane.setPage(new File(FurnMenuBar.instrPage).toURL());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jEditorPane.setFont(new Font("Arial", 0, 12));
                jEditorPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Huh?"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), jEditorPane.getBorder()));
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setPreferredSize(new Dimension(500, 300));
                JarResources jarResources = new JarResources(new File("furn.jar").getAbsolutePath());
                ImageIcon imageIcon = new ImageIcon(jarResources.getResource("icon32.gif"));
                JOptionPane.showMessageDialog(jFrame, jScrollPane, "Instructions for Furniture Mover", -1, imageIcon);
            }
        });
        ((JMenu)object3).add((JMenuItem)object2);
        object2 = new JMenuItem("About");
        ((AbstractButton)object2).setMnemonic(65);
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarResources jarResources = new JarResources(new File("furn.jar").getAbsolutePath());
                ImageIcon imageIcon = new ImageIcon(jarResources.getResource("icon32.gif"));
                JOptionPane.showMessageDialog(jFrame, FurnMenuBar.aboutMessage, "About Furniture Mover", -1, imageIcon);
            }
        });
        ((JMenu)object3).add((JMenuItem)object2);
        this.add((JMenu)object3);
    }

    public void openFile() {
        File file;
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setDialogTitle("Open File");
        int n = this.fileChooser.showOpenDialog(this.frame);
        if (n == 0 && (file = this.fileChooser.getSelectedFile()).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                this.leftPanel.getItemPanel().loadPanel(bufferedReader);
                this.rightPanel.getMainPanel().loadPanel(bufferedReader);
                fileInputStream.close();
            }
            catch (Exception exception) {
                System.out.println("ERROR: " + exception);
            }
        }
        this.fileChooser.setFileSelectionMode(1);
    }

    public void saveToFile() {
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setDialogTitle("Save File");
        int n = this.fileChooser.showSaveDialog(this.frame);
        if (n == 0) {
            Object object;
            boolean bl = true;
            File file = this.fileChooser.getSelectedFile();
            if (FurnFileFilter.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + "." + "furn");
            }
            if (file.exists()) {
                object = new JOptionPane("Overwrite " + file.getName() + "?", 3, 0);
                JDialog jDialog = ((JOptionPane)object).createDialog(this, "I Have a Question");
                jDialog.show();
                bl = (Integer)((JOptionPane)object).getValue() == 0;
            }
            if (bl) {
                try {
                    object = new PrintWriter(new FileWriter(file));
                    this.leftPanel.getItemPanel().savePanel((PrintWriter)object);
                    this.rightPanel.getMainPanel().savePanel((PrintWriter)object);
                    ((PrintWriter)object).close();
                }
                catch (Exception exception) {
                    System.out.println("ERROR: " + exception);
                }
            }
        }
        this.fileChooser.setFileSelectionMode(1);
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }
}

