/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class ItemPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    Frame frame;
    private ItemScrollPanel itemScrollPanel;
    JLabel statusBar;
    private ArrayList items;
    private ItemPopupMenu itemPopup;
    private int selectedItem;
    private int mx;
    private int my;
    private static final int ITEM_VERT_SPACE = 20;
    private static final int ITEM_HORIZ_SPACE = 20;
    private int SCALE_FACTOR = 3;

    public ItemPanel(JLabel jLabel, Frame frame, ItemScrollPanel itemScrollPanel) {
        this.frame = frame;
        this.itemScrollPanel = itemScrollPanel;
        this.setBackground(new Color(120, 0, 120));
        this.statusBar = jLabel;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.items = new ArrayList();
        this.itemPopup = new ItemPopupMenu();
        this.selectedItem = -1;
    }

    public void reset() {
        this.items = new ArrayList();
        this.selectedItem = -1;
        this.repaint();
    }

    public void setScaleFactor(int n) {
        if (n > 0) {
            this.SCALE_FACTOR = n;
            this.repaint();
        }
    }

    public void setBackColor(Color color) {
        this.setBackground(color);
    }

    public void savePanel(PrintWriter printWriter) {
        printWriter.println("<itemPanel>");
        printWriter.println("<items>");
        int n = 0;
        while (n < this.items.size()) {
            FurnItem furnItem = (FurnItem)this.items.get(n);
            printWriter.print("<item> ");
            printWriter.print(furnItem.getPrintableName() + " " + furnItem.getColorStr() + " " + furnItem.getWidth() + " " + furnItem.getHeight() + " " + furnItem.getLocX() + " " + furnItem.getLocY() + " " + furnItem.getShape());
            printWriter.println(" </item>");
            ++n;
        }
        printWriter.println("</items>");
        printWriter.println("</itemPanel>");
    }

    public void loadPanel(BufferedReader bufferedReader) {
        block8: {
            this.reset();
            try {
                String string = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if (!string2.equals("<itemPanel>")) break block8;
                string = bufferedReader.readLine();
                stringTokenizer = new StringTokenizer(string);
                string2 = stringTokenizer.nextToken();
                while (!string2.equals("</itemPanel>")) {
                    if (string2.equals("<items>")) {
                        string = bufferedReader.readLine();
                        stringTokenizer = new StringTokenizer(string);
                        string2 = stringTokenizer.nextToken();
                        while (!string2.equals("</items>")) {
                            if (string2.equals("<item>")) {
                                FurnItem furnItem = new FurnItem();
                                string2 = stringTokenizer.nextToken();
                                furnItem.setName(string2);
                                string2 = stringTokenizer.nextToken();
                                furnItem.setColor(string2);
                                string2 = stringTokenizer.nextToken();
                                try {
                                    int n = Integer.parseInt(string2);
                                    furnItem.setWidth(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setHeight(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setLocX(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setLocY(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setShape(n);
                                    this.items.add(furnItem);
                                    string2 = stringTokenizer.nextToken();
                                }
                                catch (Exception exception) {
                                    System.out.println("ERROR! " + exception);
                                    this.items.add(furnItem);
                                }
                            }
                            string = bufferedReader.readLine();
                            stringTokenizer = new StringTokenizer(string);
                            string2 = stringTokenizer.nextToken();
                        }
                    }
                    string = bufferedReader.readLine();
                    stringTokenizer = new StringTokenizer(string);
                    string2 = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR in ItemPanel! " + exception);
            }
        }
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = 0;
        while (n < this.items.size()) {
            this.drawItem(graphics, (FurnItem)this.items.get(n));
            ++n;
        }
        if (this.selectedItem != -1) {
            this.drawSelection(graphics);
        }
    }

    private void drawItem(Graphics graphics, FurnItem furnItem) {
        graphics.setColor(furnItem.getColor());
        if (furnItem.getShape() == 0) {
            graphics.fillRect(furnItem.getLocX(), furnItem.getLocY(), furnItem.getWidth() * this.SCALE_FACTOR, furnItem.getHeight() * this.SCALE_FACTOR);
        } else {
            graphics.fillOval(furnItem.getLocX(), furnItem.getLocY(), furnItem.getWidth() * this.SCALE_FACTOR, furnItem.getHeight() * this.SCALE_FACTOR);
        }
        graphics.setFont(new Font("SansSerif", 0, 12));
        graphics.drawString(furnItem.getName(), furnItem.getLocX(), furnItem.getLocY() - 1);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (furnItem.getLocX() + furnItem.getWidth() * this.SCALE_FACTOR > this.getWidth()) {
            n = furnItem.getLocX() + furnItem.getWidth() * this.SCALE_FACTOR + 20;
        }
        if (furnItem.getLocY() + furnItem.getHeight() * this.SCALE_FACTOR > this.getHeight()) {
            n2 = furnItem.getLocY() + furnItem.getHeight() * this.SCALE_FACTOR + 20;
        }
        this.setPreferredSize(new Dimension(n, n2));
        this.revalidate();
    }

    private void drawSelection(Graphics graphics) {
        if (this.selectedItem == -1) {
            return;
        }
        int n = ((FurnItem)this.items.get(this.selectedItem)).getLocY();
        int n2 = 1;
        graphics.setColor(Color.white);
        graphics.fillArc(n2, n, 18, 10, -90, 180);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        this.selectedItem = this.getSelectedItem(this.mx, this.my);
        if (mouseEvent.isPopupTrigger() && this.selectedItem != -1) {
            this.itemPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void addNewItem() {
        FurnItem furnItem = new FurnItem();
        ItemPropertiesDialog itemPropertiesDialog = new ItemPropertiesDialog(this.frame, furnItem);
        itemPropertiesDialog.pack();
        ((Component)itemPropertiesDialog).setVisible(true);
        if (itemPropertiesDialog.isOK()) {
            int n = 20;
            int n2 = 20;
            if (this.items.size() != 0) {
                FurnItem furnItem2 = (FurnItem)this.items.get(this.items.size() - 1);
                n2 += furnItem2.getLocY() + furnItem2.getHeight() * this.SCALE_FACTOR;
            }
            furnItem.setLocX(n);
            furnItem.setLocY(n2);
            this.items.add(furnItem);
            this.repaint();
        }
    }

    public void addOldItem(FurnItem furnItem) {
        int n = 20;
        int n2 = 20;
        if (this.items.size() != 0) {
            FurnItem furnItem2 = (FurnItem)this.items.get(this.items.size() - 1);
            n2 += furnItem2.getLocY() + furnItem2.getHeight() * this.SCALE_FACTOR;
        }
        furnItem.setLocX(n);
        furnItem.setLocY(n2);
        this.items.add(furnItem);
        this.repaint();
    }

    public void viewItemProperties() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return;
        }
        FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
        ItemPropertiesDialog itemPropertiesDialog = new ItemPropertiesDialog(this.frame, furnItem);
        itemPropertiesDialog.pack();
        ((Component)itemPropertiesDialog).setVisible(true);
        this.repositionItems();
        this.selectedItem = -1;
        this.repaint();
    }

    public FurnItem deleteItem() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return new FurnItem();
        }
        FurnItem furnItem = (FurnItem)this.items.remove(this.selectedItem);
        this.repositionItems();
        this.selectedItem = -1;
        this.repaint();
        return furnItem;
    }

    public void addItemToRoom() {
        FurnItem furnItem = this.deleteItem();
        this.itemScrollPanel.getMainPanel().addItem(furnItem);
    }

    public int getSelectedItem(int n, int n2) {
        int n3 = -1;
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.items.size() && !bl) {
            FurnItem furnItem = (FurnItem)this.items.get(n4);
            if (furnItem.getShape() == 0 && n >= furnItem.getLocX() && n < furnItem.getLocX() + furnItem.getWidth() * this.SCALE_FACTOR && n2 >= furnItem.getLocY() && n2 < furnItem.getLocY() + furnItem.getHeight() * this.SCALE_FACTOR) {
                bl = true;
                n3 = n4;
            } else if (furnItem.getShape() == 1) {
                int n5 = furnItem.getWidth() * this.SCALE_FACTOR;
                int n6 = furnItem.getHeight() * this.SCALE_FACTOR;
                int n7 = n5 / 2;
                int n8 = n6 / 2;
                int n9 = furnItem.getLocX() + n7;
                int n10 = furnItem.getLocY() + n8;
                if (Math.pow((double)n - (double)n9, 2.0) / Math.pow(n7, 2.0) + Math.pow(n2 - n10, 2.0) / Math.pow(n8, 2.0) <= 1.0) {
                    bl = true;
                    n3 = n4;
                }
            }
            ++n4;
        }
        return n3;
    }

    public void repositionItems() {
        if (this.items.size() != 0) {
            ((FurnItem)this.items.get(0)).setLocY(20);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.items.size()) {
            FurnItem furnItem = (FurnItem)this.items.get(n3);
            FurnItem furnItem2 = (FurnItem)this.items.get(n3 - 1);
            furnItem.setLocY(furnItem2.getLocY() + furnItem2.getHeight() * this.SCALE_FACTOR + 20);
            if (furnItem.getLocX() + furnItem.getWidth() * this.SCALE_FACTOR > this.getWidth()) {
                n = furnItem.getLocX() + furnItem.getWidth() * this.SCALE_FACTOR + 20;
            }
            if (furnItem.getLocY() + furnItem.getHeight() * this.SCALE_FACTOR > this.getWidth()) {
                n2 = furnItem.getLocY() + furnItem.getHeight() * this.SCALE_FACTOR + 20;
            }
            ++n3;
        }
        this.setPreferredSize(new Dimension(n, n2));
        this.revalidate();
    }

    class ItemPopupMenu
    extends JPopupMenu {
        public ItemPopupMenu() {
            JMenuItem jMenuItem = new JMenuItem("Add to Room");
            jMenuItem.setMnemonic(65);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$000(this.this$1).addItemToRoom();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete");
            jMenuItem.setMnemonic(68);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$000(this.this$1).deleteItem();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Properties");
            jMenuItem.setMnemonic(80);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$000(this.this$1).viewItemProperties();
                }
            });
            this.add(jMenuItem);
        }

        static /* synthetic */ ItemPanel access$000(ItemPopupMenu itemPopupMenu) {
            return itemPopupMenu.ItemPanel.this;
        }
    }
}

