/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MainPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    Frame frame;
    JLabel statusBar;
    private MainScrollPanel mainScrollPanel;
    private WallPopupMenu wallPopup;
    private ItemPopupMenu itemPopup;
    private int mx;
    private int my;
    private int xLast;
    private int yLast;
    private int dx;
    private int dy;
    private ArrayList walls;
    private ArrayList items;
    private boolean showNames;
    private int SCALE_FACTOR = 3;
    private final int NONE = -1;
    private final int ITEM = 0;
    private final int WALL = 1;
    private int typeSelected = -1;
    private int selectedItem = -1;

    public MainPanel(JLabel jLabel, Frame frame, MainScrollPanel mainScrollPanel) {
        this.setBackground(new Color(0, 120, 120));
        this.statusBar = jLabel;
        this.frame = frame;
        this.mainScrollPanel = mainScrollPanel;
        this.wallPopup = new WallPopupMenu();
        this.itemPopup = new ItemPopupMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.items = new ArrayList();
        this.walls = new ArrayList();
    }

    public void reset() {
        this.items = new ArrayList();
        this.walls = new ArrayList();
        this.typeSelected = -1;
        this.selectedItem = -1;
        this.repaint();
    }

    public void setScaleFactor(int n) {
        if (n > 0) {
            this.SCALE_FACTOR = n;
            this.repaint();
        }
    }

    public void setBackColor(Color color) {
        this.setBackground(color);
    }

    public void savePanel(PrintWriter printWriter) {
        printWriter.println("<mainPanel>");
        printWriter.println("<walls>");
        int n = 0;
        while (n < this.walls.size()) {
            Point point = (Point)this.walls.get(n);
            printWriter.print("<corner> ");
            printWriter.print((int)point.getX() + " " + (int)point.getY());
            printWriter.println(" </corner>");
            ++n;
        }
        printWriter.println("</walls>");
        printWriter.println("<items>");
        int n2 = 0;
        while (n2 < this.items.size()) {
            FurnItem furnItem = (FurnItem)this.items.get(n2);
            printWriter.print("<item> ");
            printWriter.print(furnItem.getPrintableName() + " " + furnItem.getColorStr() + " " + furnItem.getWidth() + " " + furnItem.getHeight() + " " + furnItem.getLocX() + " " + furnItem.getLocY() + " " + furnItem.getShape());
            printWriter.println(" </item>");
            ++n2;
        }
        printWriter.println("</items>");
        printWriter.println("</mainPanel>");
    }

    public void loadPanel(BufferedReader bufferedReader) {
        block13: {
            this.reset();
            try {
                String string = bufferedReader.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if (!string2.equals("<mainPanel>")) break block13;
                string = bufferedReader.readLine();
                stringTokenizer = new StringTokenizer(string);
                string2 = stringTokenizer.nextToken();
                while (!string2.equals("</mainPanel>")) {
                    int n;
                    if (string2.equals("<walls>")) {
                        string = bufferedReader.readLine();
                        stringTokenizer = new StringTokenizer(string);
                        string2 = stringTokenizer.nextToken();
                        while (!string2.equals("</walls>")) {
                            if (string2.equals("<corner>")) {
                                try {
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    string2 = stringTokenizer.nextToken();
                                    int n2 = Integer.parseInt(string2);
                                    this.walls.add(new Point(n, n2));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                string2 = stringTokenizer.nextToken();
                            }
                            string = bufferedReader.readLine();
                            stringTokenizer = new StringTokenizer(string);
                            string2 = stringTokenizer.nextToken();
                        }
                    }
                    if ((string2 = (stringTokenizer = new StringTokenizer(string = bufferedReader.readLine())).nextToken()).equals("<items>")) {
                        string = bufferedReader.readLine();
                        stringTokenizer = new StringTokenizer(string);
                        string2 = stringTokenizer.nextToken();
                        while (!string2.equals("</items>")) {
                            if (string2.equals("<item>")) {
                                FurnItem furnItem = new FurnItem();
                                string2 = stringTokenizer.nextToken();
                                furnItem.setName(string2);
                                string2 = stringTokenizer.nextToken();
                                furnItem.setColor(string2);
                                string2 = stringTokenizer.nextToken();
                                try {
                                    n = Integer.parseInt(string2);
                                    furnItem.setWidth(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setHeight(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setLocX(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setLocY(n);
                                    string2 = stringTokenizer.nextToken();
                                    n = Integer.parseInt(string2);
                                    furnItem.setShape(n);
                                    this.items.add(furnItem);
                                    string2 = stringTokenizer.nextToken();
                                }
                                catch (Exception exception) {
                                    System.out.println("ERROR! " + exception);
                                    this.items.add(furnItem);
                                }
                            }
                            string = bufferedReader.readLine();
                            stringTokenizer = new StringTokenizer(string);
                            string2 = stringTokenizer.nextToken();
                        }
                    }
                    string = bufferedReader.readLine();
                    stringTokenizer = new StringTokenizer(string);
                    string2 = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR in MainPanel! " + exception);
            }
        }
        this.repaint();
    }

    public void setVisibleNames(boolean bl) {
        this.showNames = bl;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawGrid(graphics);
        this.drawWalls(graphics);
        int n = this.items.size() - 1;
        while (n >= 0) {
            this.drawItem(graphics, (FurnItem)this.items.get(n));
            --n;
        }
        this.resizePanel();
    }

    private void drawGrid(Graphics graphics) {
        if (this.SCALE_FACTOR == 1) {
            graphics.setFont(new Font("SansSerif", 0, 8));
        } else {
            graphics.setFont(new Font("SansSerif", 0, 14));
        }
        int n = 12 * this.SCALE_FACTOR;
        while (n < this.getWidth()) {
            graphics.setColor(new Color(100, 100, 100));
            graphics.drawLine(n, 12 * this.SCALE_FACTOR, n, this.getHeight());
            graphics.setColor(new Color(70, 70, 70));
            if (this.SCALE_FACTOR != 1) {
                graphics.drawString("" + (n / 12 / this.SCALE_FACTOR - 1), n - 4, 12 * this.SCALE_FACTOR - 3);
            } else if ((n / 12 / this.SCALE_FACTOR - 1) % 2 == 0) {
                graphics.drawString("" + (n / 12 / this.SCALE_FACTOR - 1), n - 2, 12 * this.SCALE_FACTOR - 1);
            }
            n += this.SCALE_FACTOR * 12;
        }
        int n2 = 12 * this.SCALE_FACTOR;
        while (n2 < this.getHeight()) {
            graphics.setColor(new Color(100, 100, 100));
            graphics.drawLine(12 * this.SCALE_FACTOR, n2, this.getWidth(), n2);
            graphics.setColor(new Color(70, 70, 70));
            if (this.SCALE_FACTOR != 1) {
                graphics.drawString("" + (n2 / 12 / this.SCALE_FACTOR - 1), 12 * this.SCALE_FACTOR - 18, n2 + 6);
            } else if ((n2 / 12 / this.SCALE_FACTOR - 1) % 2 == 0) {
                graphics.drawString("" + (n2 / 12 / this.SCALE_FACTOR - 1), 12 * this.SCALE_FACTOR - 10, n2 + 4);
            }
            n2 += this.SCALE_FACTOR * 12;
        }
    }

    private void drawWalls(Graphics graphics) {
        if (this.walls.size() != 0) {
            int n;
            int n2;
            int n3 = (int)((Point)this.walls.get(0)).getX() * this.SCALE_FACTOR;
            int n4 = (int)((Point)this.walls.get(0)).getY() * this.SCALE_FACTOR;
            graphics.setColor(Color.black);
            int n5 = 1;
            while (n5 < this.walls.size()) {
                n2 = (int)((Point)this.walls.get(n5)).getX() * this.SCALE_FACTOR;
                n = (int)((Point)this.walls.get(n5)).getY() * this.SCALE_FACTOR;
                graphics.drawLine(n3, n4, n2, n);
                n3 = n2;
                n4 = n;
                ++n5;
            }
            graphics.drawLine(n3, n4, (int)((Point)this.walls.get(0)).getX() * this.SCALE_FACTOR, (int)((Point)this.walls.get(0)).getY() * this.SCALE_FACTOR);
            int n6 = 0;
            while (n6 < this.walls.size()) {
                n2 = (int)((Point)this.walls.get(n6)).getX() * this.SCALE_FACTOR;
                n = (int)((Point)this.walls.get(n6)).getY() * this.SCALE_FACTOR;
                this.drawWallCorner(graphics, n2, n);
                ++n6;
            }
        }
    }

    private void drawWallCorner(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.red);
        graphics.fillRect(n - 2, n2 - 2, 4, 4);
        graphics.setColor(Color.black);
        graphics.drawRect(n - 2, n2 - 2, 4, 4);
    }

    private void drawItem(Graphics graphics, FurnItem furnItem) {
        graphics.setColor(furnItem.getColor());
        if (furnItem.getShape() == 0) {
            graphics.fillRect(furnItem.getLocX() * this.SCALE_FACTOR, furnItem.getLocY() * this.SCALE_FACTOR, furnItem.getWidth() * this.SCALE_FACTOR, furnItem.getHeight() * this.SCALE_FACTOR);
        } else {
            graphics.fillOval(furnItem.getLocX() * this.SCALE_FACTOR, furnItem.getLocY() * this.SCALE_FACTOR, furnItem.getWidth() * this.SCALE_FACTOR, furnItem.getHeight() * this.SCALE_FACTOR);
        }
        if (this.showNames) {
            graphics.setFont(new Font("SansSerif", 0, 12));
            graphics.drawString(furnItem.getName(), furnItem.getLocX() * this.SCALE_FACTOR, furnItem.getLocY() * this.SCALE_FACTOR - 1);
        }
    }

    private void resizePanel() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.items.size()) {
            FurnItem furnItem = (FurnItem)this.items.get(n3);
            if (furnItem.getLocX() * this.SCALE_FACTOR + furnItem.getWidth() * this.SCALE_FACTOR > n) {
                n = furnItem.getLocX() * this.SCALE_FACTOR + furnItem.getWidth() * this.SCALE_FACTOR;
            }
            if (furnItem.getLocY() * this.SCALE_FACTOR + furnItem.getHeight() * this.SCALE_FACTOR > n2) {
                n2 = furnItem.getLocY() * this.SCALE_FACTOR + furnItem.getHeight() * this.SCALE_FACTOR;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.walls.size()) {
            Point point = (Point)this.walls.get(n4);
            if (point.getX() * (double)this.SCALE_FACTOR + 5.0 > (double)n) {
                n = (int)point.getX() * this.SCALE_FACTOR + 5;
            }
            if (point.getY() * (double)this.SCALE_FACTOR + 5.0 > (double)n2) {
                n2 = (int)point.getY() * this.SCALE_FACTOR + 5;
            }
            ++n4;
        }
        this.setPreferredSize(new Dimension(n + 50, n2 + 50));
        this.revalidate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        this.selectedItem = this.getSelectedItem(this.mx, this.my);
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (this.selectedItem != -1) {
            if (this.typeSelected == 0) {
                FurnItem furnItem;
                if (this.selectedItem != 0) {
                    furnItem = (FurnItem)this.items.remove(this.selectedItem);
                    this.selectedItem = 0;
                    this.items.add(this.selectedItem, furnItem);
                    this.repaint();
                } else {
                    furnItem = (FurnItem)this.items.get(this.selectedItem);
                }
                this.xLast = furnItem.getLocX() * this.SCALE_FACTOR;
                this.yLast = furnItem.getLocY() * this.SCALE_FACTOR;
                this.dx = this.mx - this.xLast;
                this.dy = this.my - this.yLast;
            } else if (this.typeSelected == 1) {
                // empty if block
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        this.selectedItem = this.getSelectedItem(this.mx, this.my);
        if (mouseEvent.isPopupTrigger()) {
            if (this.selectedItem != -1 && this.typeSelected == 0) {
                this.itemPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.wallPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        if (this.selectedItem == -1) {
            return;
        }
        if (mouseEvent.getModifiers() == 4) {
            return;
        }
        if (this.typeSelected == 0) {
            this.doItemDrag();
        } else if (this.typeSelected == 1) {
            this.doWallDrag();
        }
    }

    private void doItemDrag() {
        FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
        int n = this.mx - this.dx;
        int n2 = this.my - this.dy;
        n2 /= this.SCALE_FACTOR;
        if ((n /= this.SCALE_FACTOR) >= 0) {
            furnItem.setLocX(n);
        } else {
            furnItem.setLocX(0);
        }
        if (n2 >= 0) {
            furnItem.setLocY(n2);
        } else {
            furnItem.setLocY(0);
        }
        int n3 = furnItem.getLocX() * this.SCALE_FACTOR > this.xLast ? this.xLast : furnItem.getLocX() * this.SCALE_FACTOR;
        int n4 = furnItem.getLocY() * this.SCALE_FACTOR > this.yLast ? this.yLast : furnItem.getLocY() * this.SCALE_FACTOR;
        int n5 = furnItem.getLocX() * this.SCALE_FACTOR > this.xLast ? furnItem.getLocX() * this.SCALE_FACTOR - this.xLast + furnItem.getWidth() * this.SCALE_FACTOR : this.xLast - furnItem.getLocX() * this.SCALE_FACTOR + furnItem.getWidth() * this.SCALE_FACTOR;
        int n6 = furnItem.getLocY() * this.SCALE_FACTOR > this.yLast ? furnItem.getLocY() * this.SCALE_FACTOR - this.yLast + furnItem.getHeight() * this.SCALE_FACTOR : this.yLast - furnItem.getLocY() * this.SCALE_FACTOR + furnItem.getHeight() * this.SCALE_FACTOR;
        this.repaint(n3, n4 - 10, n5 += furnItem.getName().length() * 14, n6 + 10);
        this.xLast = furnItem.getLocX() * this.SCALE_FACTOR;
        this.yLast = furnItem.getLocY() * this.SCALE_FACTOR;
    }

    private void doWallDrag() {
        Point point = (Point)this.walls.get(this.selectedItem);
        int n = this.mx / this.SCALE_FACTOR;
        int n2 = this.my / this.SCALE_FACTOR;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        point.setLocation(n, n2);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void addItem(FurnItem furnItem) {
        furnItem.setLocX(0);
        furnItem.setLocY(0);
        this.items.add(furnItem);
        this.repaint();
    }

    public void unAddItem() {
        this.mainScrollPanel.getItemPanel().addOldItem((FurnItem)this.items.remove(this.selectedItem));
        this.selectedItem = -1;
        this.repaint();
    }

    public int getSelectedItem(int n, int n2) {
        int n3;
        int n4 = -1;
        this.typeSelected = -1;
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.items.size() && !bl) {
            FurnItem furnItem = (FurnItem)this.items.get(n5);
            if (furnItem.getShape() == 0 && n >= furnItem.getLocX() * this.SCALE_FACTOR && n < (furnItem.getLocX() + furnItem.getWidth()) * this.SCALE_FACTOR && n2 >= furnItem.getLocY() * this.SCALE_FACTOR && n2 < (furnItem.getLocY() + furnItem.getHeight()) * this.SCALE_FACTOR) {
                bl = true;
                n4 = n5;
                this.typeSelected = 0;
            } else if (furnItem.getShape() == 1) {
                int n6 = furnItem.getWidth() * this.SCALE_FACTOR;
                n3 = furnItem.getHeight() * this.SCALE_FACTOR;
                int n7 = n6 / 2;
                int n8 = n3 / 2;
                int n9 = furnItem.getLocX() * this.SCALE_FACTOR + n7;
                int n10 = furnItem.getLocY() * this.SCALE_FACTOR + n8;
                if (Math.pow((double)n - (double)n9, 2.0) / Math.pow(n7, 2.0) + Math.pow(n2 - n10, 2.0) / Math.pow(n8, 2.0) <= 1.0) {
                    bl = true;
                    n4 = n5;
                    this.typeSelected = 0;
                }
            }
            ++n5;
        }
        if (!bl) {
            n3 = 0;
            while (n3 < this.walls.size() && !bl) {
                Point point = (Point)this.walls.get(n3);
                if ((double)n >= point.getX() * (double)this.SCALE_FACTOR - (double)this.SCALE_FACTOR && (double)n < point.getX() * (double)this.SCALE_FACTOR + (double)this.SCALE_FACTOR && (double)n2 >= point.getY() * (double)this.SCALE_FACTOR - (double)this.SCALE_FACTOR && (double)n2 < point.getY() * (double)this.SCALE_FACTOR + (double)this.SCALE_FACTOR) {
                    bl = true;
                    n4 = n3;
                    this.typeSelected = 1;
                }
                ++n3;
            }
        }
        return n4;
    }

    public void viewItemProperties() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return;
        }
        FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
        ItemPropertiesDialog itemPropertiesDialog = new ItemPropertiesDialog(this.frame, furnItem);
        itemPropertiesDialog.pack();
        ((Component)itemPropertiesDialog).setVisible(true);
        this.selectedItem = -1;
        this.repaint();
    }

    public void destroyItem() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return;
        }
        JOptionPane jOptionPane = new JOptionPane("Destroy this item?", 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, "Double Check");
        jDialog.show();
        if ((Integer)jOptionPane.getValue() == 0) {
            this.items.remove(this.selectedItem);
        }
        this.selectedItem = -1;
        this.repaint();
    }

    public void rotateItem() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return;
        }
        FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
        int n = furnItem.getWidth();
        furnItem.setWidth(furnItem.getHeight());
        furnItem.setHeight(n);
        this.selectedItem = -1;
        this.repaint();
    }

    public void addCorner() {
        int n = this.getWallCornerIndex();
        if (n != this.walls.size()) {
            try {
                this.walls.add(n, new Point(this.mx / this.SCALE_FACTOR, this.my / this.SCALE_FACTOR));
            }
            catch (Exception exception) {}
        } else {
            this.walls.add(new Point(this.mx / this.SCALE_FACTOR, this.my / this.SCALE_FACTOR));
        }
        this.repaint();
    }

    private int getWallCornerIndex() {
        int n = this.walls.size();
        if (this.walls.size() > 0) {
            Point point = (Point)this.walls.get(0);
            boolean bl = false;
            int n2 = 1;
            while (n2 < this.walls.size() && !bl) {
                double d;
                double d2;
                Point point2 = (Point)this.walls.get(n2);
                double d3 = point.getX();
                double d4 = point.getY();
                double d5 = point2.getX();
                double d6 = this.mx / this.SCALE_FACTOR;
                double d7 = point2.getY();
                double d8 = Math.abs(((d3 - d6) * (d7 - d4) - (d4 - (d2 = (double)(this.my / this.SCALE_FACTOR))) * (d5 - d3)) / (d = Math.sqrt(Math.pow(d5 - d3, 2.0) + Math.pow(d7 - d4, 2.0))));
                if (d8 * (double)this.SCALE_FACTOR < 8.0) {
                    double d9 = Math.sqrt(Math.pow(d, 2.0) + 64.0);
                    double d10 = Math.sqrt(Math.pow(d6 - d3, 2.0) + Math.pow(d2 - d4, 2.0));
                    double d11 = Math.sqrt(Math.pow(d6 - d5, 2.0) + Math.pow(d2 - d7, 2.0));
                    if (d10 <= d9 && d11 <= d9) {
                        bl = true;
                        n = n2;
                    }
                }
                point = point2;
                ++n2;
            }
        }
        return n;
    }

    public void deleteCorner() {
        if (this.typeSelected != 1) {
            return;
        }
        if (this.selectedItem != -1 && this.selectedItem < this.walls.size()) {
            this.walls.remove(this.selectedItem);
            this.repaint();
        }
    }

    class ItemPopupMenu
    extends JPopupMenu {
        public ItemPopupMenu() {
            JMenuItem jMenuItem = new JMenuItem("Rotate");
            jMenuItem.setMnemonic(79);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).rotateItem();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Properties");
            jMenuItem.setMnemonic(80);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).viewItemProperties();
                }
            });
            this.add(jMenuItem);
            this.addSeparator();
            jMenuItem = new JMenuItem("Remove from Room");
            jMenuItem.setMnemonic(82);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).unAddItem();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Destroy");
            jMenuItem.setMnemonic(68);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).destroyItem();
                }
            });
            this.add(jMenuItem);
        }

        static /* synthetic */ MainPanel access$100(ItemPopupMenu itemPopupMenu) {
            return itemPopupMenu.MainPanel.this;
        }
    }

    class WallPopupMenu
    extends JPopupMenu {
        public WallPopupMenu() {
            JMenuItem jMenuItem = new JMenuItem("New corner");
            jMenuItem.setMnemonic(78);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    WallPopupMenu.access$000(this.this$1).addCorner();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete corner");
            jMenuItem.setMnemonic(68);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    WallPopupMenu.access$000(this.this$1).deleteCorner();
                }
            });
            this.add(jMenuItem);
            this.addSeparator();
            jMenuItem = new JMenuItem("Add Door");
            jMenuItem.setMnemonic(82);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            jMenuItem.setEnabled(false);
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Add Window");
            jMenuItem.setMnemonic(87);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            jMenuItem.setEnabled(false);
            this.add(jMenuItem);
        }

        static /* synthetic */ MainPanel access$000(WallPopupMenu wallPopupMenu) {
            return wallPopupMenu.MainPanel.this;
        }
    }
}

