/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class OptionDialog
extends JDialog {
    private JOptionPane optionPane;
    private boolean ok;

    public OptionDialog(final Frame frame, final FurnMenuBar furnMenuBar) {
        super(frame, true);
        this.setTitle("Furniture Mover Options");
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel2.add(new JLabel("Left Pane's Background Color:"));
        final JLabel jLabel = new JLabel();
        jLabel.setBackground(furnMenuBar.leftBackColor);
        jLabel.setOpaque(true);
        jLabel.setPreferredSize(new Dimension(20, 20));
        final JColorChooser jColorChooser = new JColorChooser(furnMenuBar.leftBackColor);
        JButton jButton = new JButton("Select");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(frame, "Select Background Color", furnMenuBar.leftBackColor);
                if (color != null) {
                    jLabel.setBackground(color);
                }
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jLabel);
        jPanel3.add(new JLabel("Right Pane's Background Color:"));
        final JLabel jLabel2 = new JLabel();
        jLabel2.setBackground(furnMenuBar.rightBackColor);
        jLabel2.setOpaque(true);
        jLabel2.setPreferredSize(new Dimension(20, 20));
        final JColorChooser jColorChooser2 = new JColorChooser(furnMenuBar.rightBackColor);
        JButton jButton2 = new JButton("Select");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(frame, "Select Background Color", furnMenuBar.rightBackColor);
                if (color != null) {
                    jLabel2.setBackground(color);
                }
            }
        });
        jPanel3.add(jButton2);
        jPanel3.add(jLabel2);
        jPanel4.add(new JLabel("Show Names in Right Pane:"));
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(furnMenuBar.showNames);
        jPanel4.add(jCheckBox);
        jPanel5.add(new JLabel("Working Directory:"));
        final JTextField jTextField = new JTextField(20);
        try {
            jTextField.setText(furnMenuBar.getFileChooser().getCurrentDirectory().getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JButton jButton3 = new JButton("Browse");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = furnMenuBar.getFileChooser();
                jFileChooser.setDialogTitle("Browse");
                int n = jFileChooser.showDialog(frame, "Select");
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        if (file.isDirectory()) {
                            jTextField.setText(file.getCanonicalPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        jPanel5.add(jTextField);
        jPanel5.add(jButton3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        Object[] objectArray = new Object[]{"Apply", "Cancel"};
        this.optionPane = new JOptionPane(jPanel, -1, 2, null, objectArray, objectArray[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                OptionDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (OptionDialog.this.isVisible() && propertyChangeEvent.getSource() == OptionDialog.this.optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = OptionDialog.this.optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    OptionDialog.this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object.equals("Apply")) {
                        furnMenuBar.showNames = jCheckBox.isSelected();
                        furnMenuBar.leftBackColor = jLabel.getBackground();
                        furnMenuBar.rightBackColor = jLabel2.getBackground();
                        OptionDialog.this.ok = true;
                        ((Component)OptionDialog.this).setVisible(false);
                    } else {
                        OptionDialog.this.ok = false;
                        ((Component)OptionDialog.this).setVisible(false);
                    }
                }
            }
        });
    }

    public boolean isOK() {
        return this.ok;
    }
}

