/*
 * Decompiled with CFR 0.152.
 */
package qos.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import qos.app.JarResources;
import qos.app.MainPlayScrollPanel;
import qos.app.QueenMenuBar;
import qos.app.ScorePanel;

public class GameWindow {
    static final String queenIconLocation = "qos/images/Q.gif";
    static JFrame frame;
    JLabel statusBar;

    public void createFrame() {
        frame = new JFrame("Queen of Spades");
        ((Component)frame).setSize(720, 520);
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 1));
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.statusBar = new JLabel("Click \"Game > New\" to begin a new game");
        JTabbedPane jTabbedPane = new JTabbedPane();
        MainPlayScrollPanel mainPlayScrollPanel = new MainPlayScrollPanel(jTabbedPane, this.statusBar);
        mainPlayScrollPanel.repaint();
        ScorePanel scorePanel = new ScorePanel();
        scorePanel.repaint();
        jTabbedPane.addTab("Main Play", mainPlayScrollPanel);
        jTabbedPane.addTab("Score", scorePanel);
        jTabbedPane.setPreferredSize(new Dimension(700, 420));
        frame.getContentPane().add(jTabbedPane);
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createLoweredBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        this.statusBar.setBorder(compoundBorder);
        this.statusBar.setFont(new Font("Dialog", 0, 12));
        this.statusBar.setForeground(new Color(255, 255, 255));
        JPanel jPanel = new JPanel();
        jPanel.add(this.statusBar);
        jPanel.setPreferredSize(new Dimension(700, 20));
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.setBackground(new Color(50, 50, 50));
        jPanel.setSize(new Dimension(700, 20));
        frame.getContentPane().add(jPanel);
        frame.setJMenuBar(new QueenMenuBar(frame, jTabbedPane, this.statusBar));
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        Image image = Toolkit.getDefaultToolkit().createImage(jarResources.getResource(queenIconLocation));
        ((Frame)frame).setIconImage(image);
        ((Component)frame).setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameWindow gameWindow = new GameWindow();
        gameWindow.createFrame();
    }
}

