/*
 * Decompiled with CFR 0.152.
 */
package qos.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import qos.app.GUI_Card;
import qos.app.GUI_Hand;
import qos.app.GUI_Play;
import qos.app.MainPlayScrollPanel;

public class TableCardPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    JTabbedPane tabPane;
    JLabel statusBar;
    JButton[] choiceButtons;
    JButton[] choice2Buttons;
    private final int PILE1_X = 10;
    private final int PILE1_Y = 10;
    private final int PILE_SPACING = 20;
    private final int CARD_SPACING = 18;
    public static final int FRONT = 0;
    public static final int BACK = 1;
    private ArrayList piles;
    private int destTablePile = -1;
    private GUI_Hand movingCards;
    private int[] cardIndices;
    private int[] effectiveCardIndices;
    private GUI_Play qosPlay;
    private int handSize;
    private boolean moveInProgress;
    private boolean newTablePileMade;
    private boolean addInProgress;
    private boolean addInProgress2;
    private int mx;
    private int my;
    private int originalWidth = this.getWidth();
    private int originalHeight = this.getHeight();

    public TableCardPanel(JTabbedPane jTabbedPane, JLabel jLabel) {
        this.setBackground(new Color(0, 120, 0));
        this.moveInProgress = false;
        this.addInProgress = false;
        this.addInProgress2 = false;
        this.statusBar = jLabel;
        this.tabPane = jTabbedPane;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.choiceButtons = new JButton[0];
        this.choice2Buttons = new JButton[2];
        this.choice2Buttons[0] = new JButton("Add to back");
        this.choice2Buttons[0].setMargin(new Insets(2, 5, 2, 5));
        this.choice2Buttons[0].setVisible(false);
        this.choice2Buttons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableCardPanel.this.addCardsToPile(1);
            }
        });
        this.choice2Buttons[1] = new JButton("Add to front");
        this.choice2Buttons[1].setMargin(new Insets(2, 5, 2, 5));
        this.choice2Buttons[1].setVisible(false);
        this.choice2Buttons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableCardPanel.this.addCardsToPile(0);
            }
        });
        this.add(this.choice2Buttons[0]);
        this.add(this.choice2Buttons[1]);
    }

    public void initialize() {
        this.piles = new ArrayList();
        this.setPreferredSize(new Dimension(this.originalWidth, this.originalHeight));
        this.revalidate();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = 0;
        while (n < this.piles.size()) {
            GUI_Hand gUI_Hand = (GUI_Hand)this.piles.get(n);
            int n2 = 0;
            while (n2 < gUI_Hand.size()) {
                GUI_Card gUI_Card = gUI_Hand.getCard(n2);
                graphics.drawImage(gUI_Card.getImage(this), gUI_Card.getbx(), gUI_Card.getby(), this);
                ++n2;
            }
            ++n;
        }
        if (this.addInProgress) {
            this.drawAddOptions(graphics);
        }
        if (this.addInProgress2) {
            this.drawAddOptions2(graphics);
        }
        if (this.moveInProgress) {
            this.drawMoveCards(graphics);
        }
    }

    private void drawAddOptions(Graphics graphics) {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.piles.size()) {
            image = Toolkit.getDefaultToolkit().getImage("qos/images/arrow_up.gif");
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
            GUI_Hand gUI_Hand = (GUI_Hand)this.piles.get(n3);
            GUI_Card gUI_Card = gUI_Hand.getCard(gUI_Hand.size() - 1);
            n = gUI_Card.getbx();
            n2 = gUI_Card.getby() + gUI_Card.getImage(this).getHeight(this) + 20;
            graphics.drawImage(image, n, n2, this);
            this.choiceButtons[n3].setVisible(true);
            this.choiceButtons[n3].setLocation(n, n2 + 70);
            this.choiceButtons[n3].setSize(gUI_Card.getImage(this).getWidth(this), 25);
            ++n3;
        }
    }

    private void drawAddOptions2(Graphics graphics) {
        GUI_Hand gUI_Hand = (GUI_Hand)this.piles.get(this.destTablePile);
        GUI_Card gUI_Card = gUI_Hand.getCard(gUI_Hand.size() - 1);
        int n = gUI_Card.getbx();
        int n2 = gUI_Card.getby() + gUI_Card.getImage(this).getHeight(this) + 20;
        this.choice2Buttons[0].setVisible(true);
        this.choice2Buttons[0].setLocation(n, n2 + 70);
        this.choice2Buttons[0].setSize(100, 25);
        this.choice2Buttons[1].setVisible(true);
        this.choice2Buttons[1].setLocation(n, n2 + 95);
        this.choice2Buttons[1].setSize(100, 25);
    }

    private void drawMoveCards(Graphics graphics) {
        if (!this.moveInProgress) {
            return;
        }
        int n = 0;
        while (n < this.movingCards.size()) {
            GUI_Card gUI_Card = this.movingCards.getCard(n);
            if (!gUI_Card.isDisplaced()) {
                int n2 = gUI_Card.getbx();
                int n3 = gUI_Card.getby();
                graphics.drawImage(gUI_Card.getImage(this), n2, n3, this);
            }
            ++n;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (!this.moveInProgress) {
            return;
        }
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        boolean bl = false;
        int n = this.movingCards.size() - 1;
        while (n >= 0 && !bl) {
            object = this.movingCards.getCard(n);
            if (!((GUI_Card)object).isDisplaced() && ((GUI_Card)object).getbx() <= this.mx && this.mx < ((GUI_Card)object).getbx() + ((GUI_Card)object).getImage(this).getWidth(this) - 1 && ((GUI_Card)object).getby() <= this.my && this.my < ((GUI_Card)object).getby() + ((GUI_Card)object).getImage(this).getHeight(this) - 1) {
                if (!this.newTablePileMade) {
                    this.piles.add(new GUI_Hand());
                    this.newTablePileMade = true;
                }
                GUI_Hand gUI_Hand = (GUI_Hand)this.piles.get(this.piles.size() - 1);
                this.effectiveCardIndices[gUI_Hand.size()] = this.cardIndices[n];
                int n2 = ((GUI_Card)object).getImage(this).getWidth(this);
                gUI_Hand.addCard((GUI_Card)object);
                ((GUI_Card)object).setDisplaced(true);
                ((GUI_Card)object).setbx(10 + (18 + n2) * (this.piles.size() - 1));
                ((GUI_Card)object).setby(10 + 18 * (gUI_Hand.size() - 1));
                bl = true;
                if (((GUI_Card)object).getbx() > this.getWidth()) {
                    this.setPreferredSize(new Dimension(this.getWidth() + n2 + 18, this.getHeight()));
                    this.revalidate();
                }
                this.repaint();
            }
            --n;
        }
        if (!bl) {
            object = (GUI_Hand)this.piles.get(this.piles.size() - 1);
            int n3 = ((GUI_Hand)object).size() - 1;
            while (n3 >= 0 && !bl) {
                GUI_Card gUI_Card = ((GUI_Hand)object).getCard(n3);
                if (gUI_Card.getbx() <= this.mx && this.mx < gUI_Card.getbx() + gUI_Card.getImage(this).getWidth(this) - 1 && gUI_Card.getby() <= this.my && this.my < gUI_Card.getby() + gUI_Card.getImage(this).getHeight(this) - 1) {
                    ((GUI_Hand)object).removeCard(n3);
                    this.repositionTableCards((GUI_Hand)object);
                    int n4 = gUI_Card.getImage(this).getWidth(this);
                    gUI_Card.setbx(10 + (18 + n4) * (this.piles.size() - 1) + 18 * (this.effectiveCardIndices[n3] - this.cardIndices[0]));
                    gUI_Card.setby(200);
                    int n5 = n3;
                    while (n5 < ((GUI_Hand)object).size()) {
                        this.effectiveCardIndices[n5] = this.effectiveCardIndices[n5 + 1];
                        ++n5;
                    }
                    gUI_Card.setDisplaced(false);
                    bl = true;
                    this.repaint();
                }
                --n3;
            }
        } else if (this.movingCards.size() == ((GUI_Hand)this.piles.get(this.piles.size() - 1)).size()) {
            int n6 = 0;
            while (n6 < this.effectiveCardIndices.length) {
                this.effectiveCardIndices[n6] = this.handSize - 1 - this.effectiveCardIndices[n6];
                ++n6;
            }
            this.qosPlay.setCardsToMoveToTable(this.effectiveCardIndices);
            int n7 = this.qosPlay.doUserPlay(0, 4, this.statusBar);
            if (n7 != 0) {
                MainPlayScrollPanel mainPlayScrollPanel = (MainPlayScrollPanel)this.tabPane.getComponentAt(0);
                mainPlayScrollPanel.finishMoveCards(1, this.cardIndices);
            } else {
                if (this.newTablePileMade) {
                    this.piles.remove(this.piles.size() - 1);
                }
                MainPlayScrollPanel mainPlayScrollPanel = (MainPlayScrollPanel)this.tabPane.getComponentAt(0);
                mainPlayScrollPanel.finishMoveCards(0, this.cardIndices);
            }
            this.moveInProgress = false;
            this.newTablePileMade = false;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.moveInProgress) {
            return;
        }
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public boolean isEmpty() {
        return this.piles.isEmpty();
    }

    public void putDownCardsOnNew(GUI_Hand gUI_Hand, int[] nArray, GUI_Play gUI_Play, int n) {
        this.moveInProgress = true;
        this.newTablePileMade = false;
        this.tabPane.setSelectedIndex(1);
        this.statusBar.setText("Select cards in order of placement.");
        this.movingCards = new GUI_Hand(gUI_Hand);
        this.cardIndices = nArray;
        this.effectiveCardIndices = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.movingCards.getCard(n2).setDisplaced(false);
            ++n2;
        }
        this.qosPlay = gUI_Play;
        this.handSize = n;
        GUI_Card gUI_Card = this.movingCards.getCard(0);
        int n3 = gUI_Card.getImage(this).getWidth(this);
        int n4 = 0;
        while (n4 < this.movingCards.size()) {
            gUI_Card = this.movingCards.getCard(n4);
            gUI_Card.setby(200);
            gUI_Card.setbx(10 + (18 + n3) * this.piles.size() + 18 * n4);
            ++n4;
        }
        if (gUI_Card.getbx() + n3 > this.getWidth()) {
            this.setPreferredSize(new Dimension(gUI_Card.getbx() + n3 + 18, this.getHeight()));
            this.revalidate();
        }
        this.repaint();
    }

    public int putDownCardsOnOld(GUI_Hand gUI_Hand, int[] nArray, GUI_Play gUI_Play, int n) {
        this.addInProgress = true;
        this.tabPane.setSelectedIndex(1);
        this.statusBar.setText("Select pile to add cards to.");
        this.movingCards = gUI_Hand;
        this.cardIndices = nArray;
        this.qosPlay = gUI_Play;
        this.handSize = n;
        this.choiceButtons = new JButton[this.piles.size()];
        int n2 = 0;
        while (n2 < this.piles.size()) {
            this.choiceButtons[n2] = new JButton("Select " + n2);
            this.choiceButtons[n2].setMargin(new Insets(2, 10, 2, 10));
            this.choiceButtons[n2].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StringTokenizer stringTokenizer = new StringTokenizer(actionEvent.getActionCommand());
                    String string = stringTokenizer.nextToken();
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    TableCardPanel.this.setDestinationPile(n);
                }
            });
            this.add(this.choiceButtons[n2]);
            ++n2;
        }
        return 1;
    }

    public void setDestinationPile(int n) {
        this.addInProgress = false;
        this.addInProgress2 = true;
        int n2 = 0;
        while (n2 < this.choiceButtons.length) {
            this.choiceButtons[n2].setVisible(false);
            ++n2;
        }
        this.destTablePile = n;
        this.repaint();
    }

    private void addCardsToPile(int n) {
        this.addInProgress2 = false;
        this.choice2Buttons[0].setVisible(false);
        this.choice2Buttons[1].setVisible(false);
        int n2 = 0;
        while (n2 < this.cardIndices.length) {
            this.cardIndices[n2] = this.handSize - 1 - this.cardIndices[n2];
            ++n2;
        }
        this.qosPlay.setCardsToMoveToTable(this.cardIndices);
        this.qosPlay.setDestinationTablePile(this.destTablePile, n);
        int n3 = this.qosPlay.doUserPlay(0, 5, this.statusBar);
        int n4 = 0;
        while (n4 < this.cardIndices.length) {
            this.cardIndices[n4] = this.handSize - 1 - this.cardIndices[n4];
            ++n4;
        }
        if (n3 != 0) {
            Object object;
            GUI_Hand gUI_Hand = (GUI_Hand)this.piles.get(this.destTablePile);
            int n5 = 0;
            while (n5 < this.movingCards.size()) {
                object = new GUI_Card(this.movingCards.getCard(n5));
                int n6 = ((GUI_Card)object).getImage(this).getWidth(this);
                ((GUI_Card)object).setbx(10 + (18 + n6) * this.destTablePile);
                if (n == 0) {
                    gUI_Hand.addCard((GUI_Card)object);
                    ((GUI_Card)object).setby(10 + 18 * (gUI_Hand.size() - 1));
                } else {
                    if (n5 == 0) {
                        int n7 = 0;
                        while (n7 < gUI_Hand.size()) {
                            gUI_Hand.getCard(n7).setby(gUI_Hand.getCard(n7).getby() + 18 * this.movingCards.size());
                            ++n7;
                        }
                    }
                    ((GUI_Card)object).setby(10 + 18 * n5);
                    gUI_Hand.addCard(n5, (GUI_Card)object);
                }
                ++n5;
            }
            object = (MainPlayScrollPanel)this.tabPane.getComponentAt(0);
            ((MainPlayScrollPanel)object).resetHandCards(0);
        }
        this.repaint();
    }

    private void repositionTableCards(GUI_Hand gUI_Hand) {
        int n = 0;
        while (n < gUI_Hand.size()) {
            GUI_Card gUI_Card = gUI_Hand.getCard(n);
            gUI_Card.setby(10 + 18 * n);
            ++n;
        }
    }

    public void endTableMove() {
        this.addInProgress = false;
        this.addInProgress2 = false;
        this.moveInProgress = false;
        if (this.newTablePileMade) {
            this.piles.remove(this.piles.size() - 1);
        }
        this.newTablePileMade = false;
        int n = 0;
        while (n < this.choiceButtons.length) {
            this.choiceButtons[n].setVisible(false);
            ++n;
        }
        this.choice2Buttons[0].setVisible(false);
        this.choice2Buttons[1].setVisible(false);
        this.statusBar.setText(" ");
    }
}

