/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import qos.game.Card;
import qos.game.Rank;
import qos.game.Suit;

public class Deck {
    private Card[] contents = new Card[52];
    private int remaining = 52;
    protected static final int CARDS_IN_A_DECK = 52;

    public Deck() {
        this.contents[0] = new Card(Rank.ACE, Suit.HEARTS);
        this.contents[1] = new Card(Rank.TWO, Suit.HEARTS);
        this.contents[2] = new Card(Rank.THREE, Suit.HEARTS);
        this.contents[3] = new Card(Rank.FOUR, Suit.HEARTS);
        this.contents[4] = new Card(Rank.FIVE, Suit.HEARTS);
        this.contents[5] = new Card(Rank.SIX, Suit.HEARTS);
        this.contents[6] = new Card(Rank.SEVEN, Suit.HEARTS);
        this.contents[7] = new Card(Rank.EIGHT, Suit.HEARTS);
        this.contents[8] = new Card(Rank.NINE, Suit.HEARTS);
        this.contents[9] = new Card(Rank.TEN, Suit.HEARTS);
        this.contents[10] = new Card(Rank.JACK, Suit.HEARTS);
        this.contents[11] = new Card(Rank.QUEEN, Suit.HEARTS);
        this.contents[12] = new Card(Rank.KING, Suit.HEARTS);
        this.contents[13] = new Card(Rank.ACE, Suit.DIAMONDS);
        this.contents[14] = new Card(Rank.TWO, Suit.DIAMONDS);
        this.contents[15] = new Card(Rank.THREE, Suit.DIAMONDS);
        this.contents[16] = new Card(Rank.FOUR, Suit.DIAMONDS);
        this.contents[17] = new Card(Rank.FIVE, Suit.DIAMONDS);
        this.contents[18] = new Card(Rank.SIX, Suit.DIAMONDS);
        this.contents[19] = new Card(Rank.SEVEN, Suit.DIAMONDS);
        this.contents[20] = new Card(Rank.EIGHT, Suit.DIAMONDS);
        this.contents[21] = new Card(Rank.NINE, Suit.DIAMONDS);
        this.contents[22] = new Card(Rank.TEN, Suit.DIAMONDS);
        this.contents[23] = new Card(Rank.JACK, Suit.DIAMONDS);
        this.contents[24] = new Card(Rank.QUEEN, Suit.DIAMONDS);
        this.contents[25] = new Card(Rank.KING, Suit.DIAMONDS);
        this.contents[26] = new Card(Rank.ACE, Suit.CLUBS);
        this.contents[27] = new Card(Rank.TWO, Suit.CLUBS);
        this.contents[28] = new Card(Rank.THREE, Suit.CLUBS);
        this.contents[29] = new Card(Rank.FOUR, Suit.CLUBS);
        this.contents[30] = new Card(Rank.FIVE, Suit.CLUBS);
        this.contents[31] = new Card(Rank.SIX, Suit.CLUBS);
        this.contents[32] = new Card(Rank.SEVEN, Suit.CLUBS);
        this.contents[33] = new Card(Rank.EIGHT, Suit.CLUBS);
        this.contents[34] = new Card(Rank.NINE, Suit.CLUBS);
        this.contents[35] = new Card(Rank.TEN, Suit.CLUBS);
        this.contents[36] = new Card(Rank.JACK, Suit.CLUBS);
        this.contents[37] = new Card(Rank.QUEEN, Suit.CLUBS);
        this.contents[38] = new Card(Rank.KING, Suit.CLUBS);
        this.contents[39] = new Card(Rank.ACE, Suit.SPADES);
        this.contents[40] = new Card(Rank.TWO, Suit.SPADES);
        this.contents[41] = new Card(Rank.THREE, Suit.SPADES);
        this.contents[42] = new Card(Rank.FOUR, Suit.SPADES);
        this.contents[43] = new Card(Rank.FIVE, Suit.SPADES);
        this.contents[44] = new Card(Rank.SIX, Suit.SPADES);
        this.contents[45] = new Card(Rank.SEVEN, Suit.SPADES);
        this.contents[46] = new Card(Rank.EIGHT, Suit.SPADES);
        this.contents[47] = new Card(Rank.NINE, Suit.SPADES);
        this.contents[48] = new Card(Rank.TEN, Suit.SPADES);
        this.contents[49] = new Card(Rank.JACK, Suit.SPADES);
        this.contents[50] = new Card(Rank.QUEEN, Suit.SPADES);
        this.contents[51] = new Card(Rank.KING, Suit.SPADES);
    }

    public void shuffle() {
        Card card = new Card();
        Random random = new Random();
        int n = 0;
        while (n < 52) {
            int n2 = random.nextInt(52);
            card = this.contents[n];
            this.contents[n] = this.contents[n2];
            this.contents[n2] = card;
            ++n;
        }
    }

    public void shuffle(long l) {
        Card card = new Card();
        Random random = new Random(l);
        int n = 0;
        while (n < 52) {
            int n2 = random.nextInt(52);
            card = this.contents[n];
            this.contents[n] = this.contents[n2];
            this.contents[n2] = card;
            ++n;
        }
    }

    public Card dealACard() throws DeckExhausted {
        if (--this.remaining < 0) {
            throw new DeckExhausted("exhausted deck during deal");
        }
        return this.contents[this.remaining];
    }

    public boolean isEmpty() {
        return this.remaining < 1;
    }

    public static void main(String[] stringArray) {
        block10: {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[0]));
                Deck deck = new Deck();
                if (stringArray.length > 1) {
                    deck.shuffle(Integer.parseInt(stringArray[1]));
                } else {
                    deck.shuffle();
                }
                try {
                    try {
                        while (!deck.isEmpty()) {
                            Card card = deck.dealACard();
                            printWriter.println("card dealt: " + card);
                        }
                    }
                    catch (DeckExhausted deckExhausted) {
                        System.out.println("Dealing stock: " + deckExhausted);
                        Object var5_7 = null;
                        printWriter.close();
                        break block10;
                    }
                    Object var5_6 = null;
                    printWriter.close();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    printWriter.close();
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Open error: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.out.println("I/O error: " + iOException);
            }
        }
    }

    class DeckExhausted
    extends Exception {
        public DeckExhausted(String string) {
            super(string);
        }
    }
}

