/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

import java.util.ArrayList;
import qos.game.Card;
import qos.game.PileCard;

public class Pile {
    protected ArrayList stack = new ArrayList();

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int getSize() {
        return this.stack.size();
    }

    public boolean bottommostFaceupCardInPileIsBottommostCardInPile() {
        if (this.stack.isEmpty()) {
            return false;
        }
        return ((PileCard)this.stack.get(0)).isFaceup();
    }

    public Card topCardOnPile() throws TopCardNotVisible, EmptyPile {
        if (this.stack.isEmpty()) {
            throw new EmptyPile();
        }
        if (!((PileCard)this.stack.get(this.stack.size() - 1)).isFaceup()) {
            throw new TopCardNotVisible();
        }
        return (Card)this.stack.get(this.stack.size() - 1);
    }

    public void placeCardFacedownOnPile(Card card) {
        this.stack.add(new PileCard(card.getRank(), card.getSuit(), false));
    }

    public void placeCardFaceupOnPile(Card card) {
        this.stack.add(new PileCard(card.getRank(), card.getSuit(), true));
    }

    class EmptyPile
    extends Exception {
        public EmptyPile() {
            super("Pile is empty");
        }
    }

    class TopCardNotVisible
    extends Exception {
        public TopCardNotVisible() {
            super("Top card is not visible");
        }
    }
}

