/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

public class Rank
implements Comparable {
    private int value;
    private int points;
    public static final int ASCEND = 1;
    public static final int DESCEND = 2;
    public static final Rank TWO = new Rank(2);
    public static final Rank THREE = new Rank(3);
    public static final Rank FOUR = new Rank(4);
    public static final Rank FIVE = new Rank(5);
    public static final Rank SIX = new Rank(6);
    public static final Rank SEVEN = new Rank(7);
    public static final Rank EIGHT = new Rank(8);
    public static final Rank NINE = new Rank(9);
    public static final Rank TEN = new Rank(10);
    public static final Rank JACK = new Rank(11);
    public static final Rank QUEEN = new Rank(12);
    public static final Rank KING = new Rank(13);
    public static final Rank ACE = new Rank(14);
    public static final Rank NaR = new Rank(0);

    public Rank(int n) {
        if (n < 2 || n > 14) {
            this.value = 0;
            this.points = 0;
        } else {
            this.value = n;
            this.points = 5;
        }
        if (n == 2) {
            this.points = 25;
        } else if (n == 10 || n == 11 || n == 12 || n == 13) {
            this.points = 10;
        } else if (n == 14) {
            this.points = 15;
        }
    }

    public int compareTo(Object object) {
        Rank rank = (Rank)object;
        return this.value - rank.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rank)) {
            return false;
        }
        Rank rank = (Rank)object;
        return this.value == rank.value;
    }

    public int hashCode() {
        return this.value + 1;
    }

    public String getName() {
        return this.toString();
    }

    public int getValue() {
        return this.value;
    }

    public int getPoints() {
        return this.points;
    }

    public String toString() {
        switch (this.value) {
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "10";
            }
            case 11: {
                return "J";
            }
            case 12: {
                return "Q";
            }
            case 13: {
                return "K";
            }
            case 14: {
                return "A";
            }
        }
        return "NaR";
    }

    public Rank nextRank(int n) {
        int n2;
        if (n != 1 && n != 2) {
            return NaR;
        }
        if (this.value == 0) {
            return NaR;
        }
        if (n == 1) {
            n2 = this.value + 1;
            if (n2 > 14) {
                n2 = 2;
            }
        } else {
            n2 = this.value - 1;
            if (n2 < 2) {
                n2 = 14;
            }
        }
        return new Rank(n2);
    }
}

