/*
 * Decompiled with CFR 0.152.
 */
package qos.app;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JLabel;
import qos.app.CutDialog;
import qos.game.Card;
import qos.game.Hand;
import qos.game.QueenOfSpades;

public class GUI_Play {
    private Frame frame;
    private int numberPlayers;
    private int dealer;
    private int cutter;
    private int[] cardIndex;
    private int destTablePile;
    private int destPlacement;
    protected int percentToCut = 30;
    private static final int DEFAULT_CUT = 50;
    public static final int PLAYER1 = 0;
    public static final int GET_WASTE_PILE = 1;
    public static final int PICK_PLAYING_PILE = 2;
    public static final int PUT_CARDS_ON_TABLE = 3;
    public static final int PUT_CARDS_ON_NEW_TABLE = 4;
    public static final int PUT_CARDS_ON_OLD_TABLE = 5;
    public static final int PUT_CARD_ON_WASTE_PILE = 6;
    public static final int PRINT_GAME_STATE = 7;
    public static final int DO_COMPUTER_PLAY = 8;
    public static final int END_ROUND = 98;
    public static final int END_GAME = 99;
    public static final int NOTHING_DONE = 0;
    public static final int CONTINUE = 1;
    public static final int PLAY_PILE_DRAWN = 2;
    public static final int WASTE_PILE_DRAWN = 3;
    private static QueenOfSpades game;

    public GUI_Play(Frame frame, String[] stringArray, int n, int n2, int n3) {
        this.frame = frame;
        this.numberPlayers = n;
        game = new QueenOfSpades(this.numberPlayers, n3);
        game.setPlayer(0, stringArray[0], true);
        int n4 = 1;
        while (n4 < n) {
            game.setPlayer(n4, stringArray[n4], false);
            ++n4;
        }
        this.dealer = n2 < 0 ? 0 : (n2 >= n ? n - 1 : n2);
        this.cutter = (this.dealer + 1) % this.numberPlayers;
        this.dealCards();
    }

    private void dealCards() {
        if (this.cutter == 0) {
            CutDialog cutDialog = new CutDialog(this.frame, game.getPlayerName(0));
            cutDialog.pack();
            ((Component)cutDialog).setVisible(true);
            this.percentToCut = cutDialog.getPercent();
            game.dealCards(this.percentToCut, this.dealer);
        } else {
            game.dealCards(50, this.dealer);
        }
    }

    public void startNewHand() {
        game.startNewHand();
        this.dealer = (this.dealer + 1) % this.numberPlayers;
        this.cutter = (this.dealer + 1) % this.numberPlayers;
        this.dealCards();
    }

    public Hand getPlayerHand(int n) {
        return game.getPlayerHand(n);
    }

    public Card getTopWastePileCard() {
        return game.getTopWastePileCard();
    }

    public int doUserPlay(int n, int n2, JLabel jLabel) {
        String string = new String();
        int n3 = 0;
        if (n != 0) {
            string = game.doComputerTurn(n);
            jLabel.setText(string);
            return 1;
        }
        switch (n2) {
            case 1: {
                string = game.pickUpWastePile(n);
                jLabel.setText(string);
                n3 = 3;
                break;
            }
            case 2: {
                string = game.pickUpCardFromPlayingPile(n);
                jLabel.setText(string);
                n3 = 2;
                break;
            }
            case 4: {
                if (game.addHandCardsToNewTableHand(n, this.cardIndex)) {
                    n3 = 1;
                    string = this.cardIndex.length + " cards moved to table";
                } else {
                    string = "No cards moved";
                }
                jLabel.setText(string);
                break;
            }
            case 5: {
                if (game.addHandCardsToOldTableHand(n, this.cardIndex, this.destTablePile, this.destPlacement)) {
                    n3 = 1;
                    string = this.cardIndex.length + " cards moved to table";
                } else {
                    string = "No cards moved";
                }
                jLabel.setText(string);
                break;
            }
            case 6: {
                string = game.putCardOnWastePile(n, this.cardIndex[0]);
                jLabel.setText(string);
                n3 = 1;
            }
        }
        return n3;
    }

    public void setCardToMoveToWaste(int n) {
        this.cardIndex = new int[1];
        this.cardIndex[0] = n;
    }

    public void setCardsToMoveToTable(int[] nArray) {
        this.cardIndex = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.cardIndex[n] = nArray[n];
            ++n;
        }
    }

    public void setDestinationTablePile(int n, int n2) {
        this.destPlacement = n2;
        this.destTablePile = n;
    }

    public int[] calculateScores() {
        return game.calculateScores();
    }

    public int[] getWinner() {
        if (game.roundIsFinished()) {
            return game.getPlayerWithMostPoints();
        }
        return new int[]{-1};
    }
}

