/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

import qos.game.Rank;
import qos.game.Suit;

public class Card
implements Comparable {
    private Rank rank;
    private Suit suit;
    private int value;
    private int points;
    public static final Card NaC = new Card(Rank.NaR, Suit.NaS);

    public Card() {
        this.rank = Rank.NaR;
        this.suit = Suit.NaS;
        this.value = 0;
        this.points = 0;
    }

    public Card(Rank rank, Suit suit) {
        this.rank = rank;
        this.suit = suit;
        this.points = this.rank.getPoints();
        if (this.suit.equals(Suit.SPADES) && this.rank.equals(Rank.QUEEN)) {
            this.points = 100;
        }
    }

    public Suit getSuit() {
        return this.suit;
    }

    public Rank getRank() {
        return this.rank;
    }

    public int getPoints() {
        return this.points;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Card)) {
            return false;
        }
        Card card = (Card)object;
        return this.rank.equals(card.rank) && this.suit.equals(card.suit);
    }

    public int compareTo(Object object) {
        Card card = (Card)object;
        int n = this.rank.compareTo(card.rank);
        if (n == 0) {
            n = this.suit.compareTo(card.suit);
        }
        return n;
    }

    public int compareTo(Card card) {
        return this.rank.compareTo(card.rank);
    }

    public int hashCode() {
        return this.rank.hashCode() * this.suit.hashCode();
    }

    public int rankDistance(Card card) {
        return this.rank.getValue() - card.rank.getValue();
    }

    public String toString() {
        return this.rank + " of " + this.suit;
    }
}

