/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import qos.game.Card;
import qos.game.Deck;
import qos.game.Rank;
import qos.game.Suit;

public class DoubleDeck
extends Deck {
    private Card[] contents = new Card[104];
    private int remaining = 104;
    static int count = 0;

    public DoubleDeck() {
        this.contents[0] = new Card(Rank.ACE, Suit.HEARTS);
        this.contents[1] = new Card(Rank.TWO, Suit.HEARTS);
        this.contents[2] = new Card(Rank.THREE, Suit.HEARTS);
        this.contents[3] = new Card(Rank.FOUR, Suit.HEARTS);
        this.contents[4] = new Card(Rank.FIVE, Suit.HEARTS);
        this.contents[5] = new Card(Rank.SIX, Suit.HEARTS);
        this.contents[6] = new Card(Rank.SEVEN, Suit.HEARTS);
        this.contents[7] = new Card(Rank.EIGHT, Suit.HEARTS);
        this.contents[8] = new Card(Rank.NINE, Suit.HEARTS);
        this.contents[9] = new Card(Rank.TEN, Suit.HEARTS);
        this.contents[10] = new Card(Rank.JACK, Suit.HEARTS);
        this.contents[11] = new Card(Rank.QUEEN, Suit.HEARTS);
        this.contents[12] = new Card(Rank.KING, Suit.HEARTS);
        this.contents[13] = new Card(Rank.ACE, Suit.DIAMONDS);
        this.contents[14] = new Card(Rank.TWO, Suit.DIAMONDS);
        this.contents[15] = new Card(Rank.THREE, Suit.DIAMONDS);
        this.contents[16] = new Card(Rank.FOUR, Suit.DIAMONDS);
        this.contents[17] = new Card(Rank.FIVE, Suit.DIAMONDS);
        this.contents[18] = new Card(Rank.SIX, Suit.DIAMONDS);
        this.contents[19] = new Card(Rank.SEVEN, Suit.DIAMONDS);
        this.contents[20] = new Card(Rank.EIGHT, Suit.DIAMONDS);
        this.contents[21] = new Card(Rank.NINE, Suit.DIAMONDS);
        this.contents[22] = new Card(Rank.TEN, Suit.DIAMONDS);
        this.contents[23] = new Card(Rank.JACK, Suit.DIAMONDS);
        this.contents[24] = new Card(Rank.QUEEN, Suit.DIAMONDS);
        this.contents[25] = new Card(Rank.KING, Suit.DIAMONDS);
        this.contents[26] = new Card(Rank.ACE, Suit.CLUBS);
        this.contents[27] = new Card(Rank.TWO, Suit.CLUBS);
        this.contents[28] = new Card(Rank.THREE, Suit.CLUBS);
        this.contents[29] = new Card(Rank.FOUR, Suit.CLUBS);
        this.contents[30] = new Card(Rank.FIVE, Suit.CLUBS);
        this.contents[31] = new Card(Rank.SIX, Suit.CLUBS);
        this.contents[32] = new Card(Rank.SEVEN, Suit.CLUBS);
        this.contents[33] = new Card(Rank.EIGHT, Suit.CLUBS);
        this.contents[34] = new Card(Rank.NINE, Suit.CLUBS);
        this.contents[35] = new Card(Rank.TEN, Suit.CLUBS);
        this.contents[36] = new Card(Rank.JACK, Suit.CLUBS);
        this.contents[37] = new Card(Rank.QUEEN, Suit.CLUBS);
        this.contents[38] = new Card(Rank.KING, Suit.CLUBS);
        this.contents[39] = new Card(Rank.ACE, Suit.SPADES);
        this.contents[40] = new Card(Rank.TWO, Suit.SPADES);
        this.contents[41] = new Card(Rank.THREE, Suit.SPADES);
        this.contents[42] = new Card(Rank.FOUR, Suit.SPADES);
        this.contents[43] = new Card(Rank.FIVE, Suit.SPADES);
        this.contents[44] = new Card(Rank.SIX, Suit.SPADES);
        this.contents[45] = new Card(Rank.SEVEN, Suit.SPADES);
        this.contents[46] = new Card(Rank.EIGHT, Suit.SPADES);
        this.contents[47] = new Card(Rank.NINE, Suit.SPADES);
        this.contents[48] = new Card(Rank.TEN, Suit.SPADES);
        this.contents[49] = new Card(Rank.JACK, Suit.SPADES);
        this.contents[50] = new Card(Rank.QUEEN, Suit.SPADES);
        this.contents[51] = new Card(Rank.KING, Suit.SPADES);
        this.contents[52] = new Card(Rank.ACE, Suit.HEARTS);
        this.contents[53] = new Card(Rank.TWO, Suit.HEARTS);
        this.contents[54] = new Card(Rank.THREE, Suit.HEARTS);
        this.contents[55] = new Card(Rank.FOUR, Suit.HEARTS);
        this.contents[56] = new Card(Rank.FIVE, Suit.HEARTS);
        this.contents[57] = new Card(Rank.SIX, Suit.HEARTS);
        this.contents[58] = new Card(Rank.SEVEN, Suit.HEARTS);
        this.contents[59] = new Card(Rank.EIGHT, Suit.HEARTS);
        this.contents[60] = new Card(Rank.NINE, Suit.HEARTS);
        this.contents[61] = new Card(Rank.TEN, Suit.HEARTS);
        this.contents[62] = new Card(Rank.JACK, Suit.HEARTS);
        this.contents[63] = new Card(Rank.QUEEN, Suit.HEARTS);
        this.contents[64] = new Card(Rank.KING, Suit.HEARTS);
        this.contents[65] = new Card(Rank.ACE, Suit.DIAMONDS);
        this.contents[66] = new Card(Rank.TWO, Suit.DIAMONDS);
        this.contents[67] = new Card(Rank.THREE, Suit.DIAMONDS);
        this.contents[68] = new Card(Rank.FOUR, Suit.DIAMONDS);
        this.contents[69] = new Card(Rank.FIVE, Suit.DIAMONDS);
        this.contents[70] = new Card(Rank.SIX, Suit.DIAMONDS);
        this.contents[71] = new Card(Rank.SEVEN, Suit.DIAMONDS);
        this.contents[72] = new Card(Rank.EIGHT, Suit.DIAMONDS);
        this.contents[73] = new Card(Rank.NINE, Suit.DIAMONDS);
        this.contents[74] = new Card(Rank.TEN, Suit.DIAMONDS);
        this.contents[75] = new Card(Rank.JACK, Suit.DIAMONDS);
        this.contents[76] = new Card(Rank.QUEEN, Suit.DIAMONDS);
        this.contents[77] = new Card(Rank.KING, Suit.DIAMONDS);
        this.contents[78] = new Card(Rank.ACE, Suit.CLUBS);
        this.contents[79] = new Card(Rank.TWO, Suit.CLUBS);
        this.contents[80] = new Card(Rank.THREE, Suit.CLUBS);
        this.contents[81] = new Card(Rank.FOUR, Suit.CLUBS);
        this.contents[82] = new Card(Rank.FIVE, Suit.CLUBS);
        this.contents[83] = new Card(Rank.SIX, Suit.CLUBS);
        this.contents[84] = new Card(Rank.SEVEN, Suit.CLUBS);
        this.contents[85] = new Card(Rank.EIGHT, Suit.CLUBS);
        this.contents[86] = new Card(Rank.NINE, Suit.CLUBS);
        this.contents[87] = new Card(Rank.TEN, Suit.CLUBS);
        this.contents[88] = new Card(Rank.JACK, Suit.CLUBS);
        this.contents[89] = new Card(Rank.QUEEN, Suit.CLUBS);
        this.contents[90] = new Card(Rank.KING, Suit.CLUBS);
        this.contents[91] = new Card(Rank.ACE, Suit.SPADES);
        this.contents[92] = new Card(Rank.TWO, Suit.SPADES);
        this.contents[93] = new Card(Rank.THREE, Suit.SPADES);
        this.contents[94] = new Card(Rank.FOUR, Suit.SPADES);
        this.contents[95] = new Card(Rank.FIVE, Suit.SPADES);
        this.contents[96] = new Card(Rank.SIX, Suit.SPADES);
        this.contents[97] = new Card(Rank.SEVEN, Suit.SPADES);
        this.contents[98] = new Card(Rank.EIGHT, Suit.SPADES);
        this.contents[99] = new Card(Rank.NINE, Suit.SPADES);
        this.contents[100] = new Card(Rank.TEN, Suit.SPADES);
        this.contents[101] = new Card(Rank.JACK, Suit.SPADES);
        this.contents[102] = new Card(Rank.QUEEN, Suit.SPADES);
        this.contents[103] = new Card(Rank.KING, Suit.SPADES);
    }

    public void shuffle() {
        Card card = new Card();
        Random random = new Random();
        int n = 0;
        while (n < 104) {
            int n2 = random.nextInt(104);
            card = this.contents[n];
            this.contents[n] = this.contents[n2];
            this.contents[n2] = card;
            ++n;
        }
    }

    public void shuffle(long l) {
        Card card = new Card();
        Random random = new Random(l);
        int n = 0;
        while (n < 104) {
            int n2 = random.nextInt(104);
            card = this.contents[n];
            this.contents[n] = this.contents[n2];
            this.contents[n2] = card;
            ++n;
        }
    }

    public Card dealACard() throws Deck.DeckExhausted {
        if (--this.remaining < 0) {
            throw new Deck.DeckExhausted("exhausted deck during deal");
        }
        return this.contents[this.remaining];
    }

    public void cut(int n) {
        if (n < 1 || n > 99) {
            n = 50;
        }
        int n2 = 104 * n / 100;
        Card[] cardArray = new Card[104];
        int n3 = n2;
        while (n3 < 104) {
            cardArray[n3 - n2] = this.contents[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            cardArray[n4 + 104 - n2] = this.contents[n4];
            ++n4;
        }
        this.contents = cardArray;
    }

    public boolean isEmpty() {
        return this.remaining < 1;
    }

    public void printToFile() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("deckOut" + count + ".txt"));
            int n = 0;
            while (n < this.remaining) {
                printWriter.println(this.contents[n]);
                ++n;
            }
            printWriter.close();
            ++count;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        block9: {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[0]));
                DoubleDeck doubleDeck = new DoubleDeck();
                if (stringArray.length > 1) {
                    doubleDeck.cut(Integer.parseInt(stringArray[1]));
                }
                try {
                    try {
                        while (!doubleDeck.isEmpty()) {
                            Card card = doubleDeck.dealACard();
                            printWriter.println("card dealt: " + card);
                            System.out.println("card dealt: " + card);
                        }
                    }
                    catch (Deck.DeckExhausted deckExhausted) {
                        System.out.println("Dealing stock: " + deckExhausted);
                        Object var5_7 = null;
                        printWriter.close();
                        break block9;
                    }
                    Object var5_6 = null;
                    printWriter.close();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    printWriter.close();
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Open error: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.out.println("I/O error: " + iOException);
            }
        }
    }
}

