/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JPanel;

class Character {
    public static final int HERO = 1;
    public static final int ALT = 2;
    protected int currEnv;
    protected int locX;
    protected int locY;
    protected int type;
    protected String id;
    protected String name;
    protected Image imageL;
    protected Image imageU;
    protected Image imageR;
    protected Image imageD;
    protected int dir;
    protected boolean moveMade;
    protected boolean canMove;

    public Character() {
        this.name = new String("");
    }

    public Character(int n, int n2, String string, int n3, JPanel jPanel) {
        this.currEnv = n3;
        this.locX = n;
        this.locY = n2;
        this.id = string;
        this.name = string;
        this.dir = 4;
        this.moveMade = false;
        this.canMove = true;
        MediaTracker mediaTracker = new MediaTracker(jPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.imageL = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/chars/" + this.id + " left.gif"));
        this.imageU = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/chars/" + this.id + " back.gif"));
        this.imageR = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/chars/" + this.id + " right.gif"));
        this.imageD = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/chars/" + this.id + " front.gif"));
        mediaTracker.addImage(this.imageL, 0);
        mediaTracker.addImage(this.imageU, 0);
        mediaTracker.addImage(this.imageR, 0);
        mediaTracker.addImage(this.imageD, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getX() {
        return this.locX;
    }

    public void setX(int n) {
        if (n < this.getX()) {
            this.dir = 1;
        } else if (n > this.getX()) {
            this.dir = 3;
        }
        this.locX = n;
    }

    public int getY() {
        return this.locY;
    }

    public void setY(int n) {
        if (n < this.getY()) {
            this.dir = 2;
        } else if (n > this.getY()) {
            this.dir = 4;
        }
        this.locY = n;
    }

    public Point getLoc() {
        return new Point(this.getX(), this.getY());
    }

    public void setLoc(Point point) {
        this.locX = (int)point.getX();
        this.locY = (int)point.getY();
    }

    public void setLoc(int n, int n2) {
        this.locX = n;
        this.locY = n2;
    }

    public void setDir(int n) {
        if (n == 1 || n == 2 || n == 3 || n == 4) {
            this.dir = n;
        }
    }

    public int getDir() {
        return this.dir;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public Image getImage() {
        if (this.dir == 1) {
            return this.imageL;
        }
        if (this.dir == 2) {
            return this.imageU;
        }
        if (this.dir == 3) {
            return this.imageR;
        }
        return this.imageD;
    }

    public int getCurrEnv() {
        return this.currEnv;
    }

    public void setCurrEnv(int n) {
        this.currEnv = n;
    }

    public boolean isMoving() {
        return this.moveMade;
    }

    public void setMoving(boolean bl) {
        this.moveMade = bl;
    }

    public boolean canMove() {
        return this.canMove;
    }

    public void setCanMove(boolean bl) {
        this.canMove = bl;
    }
}

