/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;

class House
extends Environment {
    public static final int BED = 0;
    public static final int FRONT_DOOR = 1;
    public static final int STAIRS = 2;
    private static final int NONE = 0;
    private static final int FLOOR = 1;
    private static final int WALL = 2;
    private static final int DOOR = 3;
    private static final int STAIR = 4;
    private static final int BED1 = 5;
    private static final int BED2 = 6;
    private Image floor;
    private Image wall;
    private Image door;
    private Image stair;
    private Image bed1;
    private Image bed2;
    private int[][] imageArr = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 2}, {2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2}, {2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2}, {2, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2}, {2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2}, {2, 5, 6, 1, 1, 2, 1, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2}};
    private JPanel dispPanel;
    private Land land;
    private Plot plot;
    private int entrance;

    public House(Land land, JPanel jPanel, Plot plot, int n) {
        this.land = land;
        this.dispPanel = jPanel;
        this.plot = plot;
        this.entrance = n;
        MediaTracker mediaTracker = new MediaTracker(this.dispPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.floor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/floor3.gif"));
        this.wall = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/wall2.gif"));
        this.door = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/door1.gif"));
        this.stair = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/stair1.gif"));
        this.bed1 = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/bed1a.gif"));
        this.bed2 = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/bed1b.gif"));
        mediaTracker.addImage(this.floor, 0);
        mediaTracker.addImage(this.wall, 0);
        mediaTracker.addImage(this.door, 0);
        mediaTracker.addImage(this.stair, 0);
        mediaTracker.addImage(this.bed1, 0);
        mediaTracker.addImage(this.bed2, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.AREA_WIDTH = 5;
        this.AREA_HEIGHT = 6;
        this.X0 = 200;
        this.Y0 = 100;
    }

    public ArrayList getAltChars() {
        return new ArrayList();
    }

    public Point getInitPos() {
        if (this.entrance == 0) {
            return new Point(1, 5);
        }
        if (this.entrance == 1) {
            return new Point(6, 6);
        }
        return new Point(10, 1);
    }

    public void drawBack(Graphics graphics) {
        int n = 0;
        while (n < this.imageArr.length) {
            int n2 = 0;
            while (n2 < this.imageArr[n].length) {
                if (this.imageArr[n][n2] == 2) {
                    graphics.drawImage(this.wall, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 1) {
                    graphics.drawImage(this.floor, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 3) {
                    graphics.drawImage(this.door, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 4) {
                    graphics.drawImage(this.floor, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                    graphics.drawImage(this.stair, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 5) {
                    graphics.drawImage(this.floor, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                    graphics.drawImage(this.bed1, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 6) {
                    graphics.drawImage(this.floor, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                    graphics.drawImage(this.bed2, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean isBackStatic() {
        return true;
    }

    public boolean isMoveOK(int n, int n2, int n3, ArrayList arrayList) {
        return n2 < this.imageArr.length && n < this.imageArr[0].length && (this.imageArr[n2][n] == 1 || this.imageArr[n2][n] == 0 || this.imageArr[n2][n] == 4);
    }

    public void move(int n, int n2, int n3, int n4) {
        if (this.imageArr[n2][n] == 0) {
            this.land.changeEnv(3, 0);
        } else if (this.imageArr[n2][n] == 4) {
            this.land.changeEnv(2, 0);
        }
    }

    public int openDoor(Hero hero) {
        int n = hero.getX();
        int n2 = hero.getY();
        if (n == 6 && n2 == 6 && hero.getDir() == 4) {
            this.imageArr[7][6] = 0;
            return 1;
        }
        if (n == 6 && n2 == 4 && hero.getDir() == 3) {
            this.imageArr[4][7] = 1;
            return 1;
        }
        return 2;
    }

    public String useItem(Hero hero, int n) {
        return new String("Can't use that item.");
    }

    public boolean doKeyPress(int n, ArrayList arrayList, ArrayList arrayList2) {
        Character character = (Character)arrayList.get(0);
        int n2 = character.getX();
        int n3 = character.getY();
        if (n == 68) {
            if (n2 == 6 && n3 == 6 && character.getDir() == 4) {
                this.imageArr[7][6] = 0;
                return true;
            }
            if (n2 == 6 && n3 == 4 && character.getDir() == 3) {
                this.imageArr[4][7] = 1;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isShowItems(Character character) {
        return false;
    }

    public boolean isQuestion(Hero hero, Character character, int n) {
        return false;
    }

    public String getDialogString(Hero hero, Character character, int n) {
        return "No one is there.";
    }

    public void incDialog(Character character) {
    }

    public void escDialog(Character character) {
    }

    public boolean isMoreDialog(Character character) {
        return false;
    }

    public void doYesDialog(Hero hero, int n) {
    }
}

