/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;

class HouseBasement
extends Environment {
    public static final int STAIRS = 0;
    private static final int NONE = 0;
    private static final int FLOOR = 1;
    private static final int WALL = 2;
    private static final int STAIR = 3;
    private static final int POTS = 4;
    private Image floor;
    private Image wall;
    private Image stair;
    private Image pots;
    private int[][] imageArr = new int[][]{{2, 2, 2, 2, 0}, {2, 3, 1, 2, 2}, {2, 1, 1, 1, 2}, {2, 1, 1, 4, 2}, {2, 2, 2, 2, 2}};
    private JPanel dispPanel;
    private Land land;
    private Plot plot;
    private ArrayList stateArr;
    private int entrance;

    public HouseBasement(Land land, JPanel jPanel, Plot plot, int n) {
        this.land = land;
        this.dispPanel = jPanel;
        this.plot = plot;
        this.entrance = n;
        this.load();
        MediaTracker mediaTracker = new MediaTracker(this.dispPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.floor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/floor5.gif"));
        this.wall = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/wall2.gif"));
        this.stair = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/stair2.gif"));
        this.pots = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/pots.gif"));
        mediaTracker.addImage(this.floor, 0);
        mediaTracker.addImage(this.wall, 0);
        mediaTracker.addImage(this.stair, 0);
        mediaTracker.addImage(this.pots, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.X0 = 200;
        this.Y0 = 100;
    }

    private void load() {
        this.stateArr = this.plot.getInfo(2);
    }

    public ArrayList getAltChars() {
        return new ArrayList();
    }

    public Point getInitPos() {
        return new Point(1, 1);
    }

    public void drawBack(Graphics graphics) {
        int n = 0;
        while (n < this.imageArr.length) {
            int n2 = 0;
            while (n2 < this.imageArr[n].length) {
                if (this.imageArr[n][n2] == 2) {
                    graphics.drawImage(this.wall, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 1) {
                    graphics.drawImage(this.floor, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 3) {
                    graphics.drawImage(this.floor, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                    graphics.drawImage(this.stair, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                } else if (this.imageArr[n][n2] == 4) {
                    graphics.drawImage(this.floor, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                    if ((Integer)this.stateArr.get(0) == 1) {
                        graphics.drawImage(this.pots, n2 * 25 + this.X0, n * 25 + this.Y0, this.dispPanel);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean isBackStatic() {
        return true;
    }

    public boolean isMoveOK(int n, int n2, int n3, ArrayList arrayList) {
        return n2 < this.imageArr.length && n < this.imageArr[0].length && (this.imageArr[n2][n] == 1 || this.imageArr[n2][n] == 0 || this.imageArr[n2][n] == 3 || this.imageArr[n2][n] == 4);
    }

    public void move(int n, int n2, int n3, int n4) {
        if (this.imageArr[n2][n] == 3) {
            this.land.changeEnv(1, 2);
        }
    }

    public int openDoor(Hero hero) {
        return 2;
    }

    public String useItem(Hero hero, int n) {
        return new String("Can't use that item.");
    }

    public boolean doKeyPress(int n, ArrayList arrayList, ArrayList arrayList2) {
        boolean bl = false;
        Character character = (Character)arrayList.get(0);
        int n2 = character.getX();
        int n3 = character.getY();
        if (n == 71 && this.imageArr[n3][n2] == 4 && (Integer)this.stateArr.get(0) == 1) {
            this.stateArr.set(0, new Integer(0));
            ((Hero)character).addItem("Pots");
            bl = true;
        }
        return bl;
    }

    public boolean isShowItems(Character character) {
        return false;
    }

    public boolean isQuestion(Hero hero, Character character, int n) {
        return false;
    }

    public String getDialogString(Hero hero, Character character, int n) {
        return "No one is there.";
    }

    public void incDialog(Character character) {
    }

    public void escDialog(Character character) {
    }

    public boolean isMoreDialog(Character character) {
        return false;
    }

    public void doYesDialog(Hero hero, int n) {
    }
}

