/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;

class BarrenRoadMarket
extends Place {
    public static final int ENTRANCE = 0;
    private static final int NONE = 0;
    private static final int WALL = 1;
    private static final int FLOOR = 2;
    private static final int ARMOR = 3;
    private ArrayList altCharArr;
    private Image wall;
    private Image floor;
    private Image armor;
    private int[][] imageArr = new int[][]{{1, 1, 1, 1, 1, 1}, {1, 3, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 0}, {1, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 1}, {1, 1, 1, 1, 1, 1}};
    private Plot plot;
    private int entrance;

    public BarrenRoadMarket(Plot plot, int n) {
        this.plot = plot;
        this.entrance = n;
        JPanel jPanel = new JPanel();
        MediaTracker mediaTracker = new MediaTracker(jPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.wall = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/wall2.gif"));
        this.floor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/floor5.gif"));
        this.armor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/armor1.gif"));
        mediaTracker.addImage(this.wall, 0);
        mediaTracker.addImage(this.floor, 0);
        mediaTracker.addImage(this.armor, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.X0 = 225;
        this.Y0 = 100;
    }

    public Point getInitPos() {
        return new Point(100 + this.X0, 100 + this.Y0);
    }

    public Populace getAltChars(World world) {
        Populace populace = new Populace(world);
        AltChar altChar = new AltChar("merch1", "Eileen", world);
        altChar.setX(25 + this.X0);
        altChar.setY(50 + this.Y0);
        altChar.setMoveable(false);
        populace.addPerson(altChar);
        altChar = new AltChar("merch1", "Jack", world);
        altChar.setX(25 + this.X0);
        altChar.setY(125 + this.Y0);
        altChar.setMoveable(false);
        populace.addPerson(altChar);
        return populace;
    }

    public int paintBack(Graphics graphics, DispPanel dispPanel, int n, int n2) {
        int n3 = 0;
        while (n3 < this.imageArr.length) {
            int n4 = n3 * 25 + this.Y0;
            int n5 = 0;
            while (n5 < this.imageArr[n3].length) {
                int n6 = n5 * 25 + this.X0;
                if (this.imageArr[n3][n5] == 1) {
                    graphics.drawImage(this.wall, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 2) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 3) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                    graphics.drawImage(this.armor, n6, n4, dispPanel);
                }
                ++n5;
            }
            ++n3;
        }
        return 2;
    }

    public boolean isBackStatic() {
        return true;
    }

    public int isMoveOK(int n, int n2, int n3) {
        int n4 = (n2 - this.X0) / 25;
        int n5 = (n3 - this.Y0) / 25;
        if (n == 1) {
            --n4;
        } else if (n == 2) {
            --n5;
        } else if (n == 3) {
            ++n4;
        } else if (n == 4) {
            ++n5;
        }
        if (n5 < this.imageArr.length && n4 < this.imageArr[0].length && (this.imageArr[n5][n4] == 2 || this.imageArr[n5][n4] == 0)) {
            return 1;
        }
        return 2;
    }

    public int doMove(int n, int n2, int n3) {
        int n4 = (n3 - this.Y0) / 25;
        int n5 = (n2 - this.X0) / 25;
        if (this.imageArr[n4][n5] == 0) {
            return 4;
        }
        return 0;
    }

    public int doTransit(int n, int n2) {
        int n3 = (n2 - this.Y0) / 25;
        int n4 = (n - this.X0) / 25;
        if (this.imageArr[n3][n4] == 0) {
            return 3;
        }
        return 0;
    }

    public String useItem(Hero hero, int n) {
        return new String("Can't use that item.");
    }

    public Item getItem(Hero hero) {
        return null;
    }

    public int command(int n, Hero hero) {
        if (n == 4) {
            return 7;
        }
        return 0;
    }
}

