/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;

class HouseBasement
extends Place {
    public static final int STAIRS = 0;
    private static final int NONE = 0;
    private static final int FLOOR = 1;
    private static final int WALL = 2;
    private static final int STAIR = 3;
    private static final int POTS = 4;
    private Image floor;
    private Image wall;
    private Image stair;
    private Image pots;
    private int[][] imageArr = new int[][]{{2, 2, 2, 2, 0}, {2, 3, 1, 2, 2}, {2, 1, 1, 1, 2}, {2, 1, 1, 4, 2}, {2, 2, 2, 2, 2}};
    private Plot plot;
    private ArrayList items;
    private ArrayList stateArr;
    private int entrance;

    public HouseBasement(Plot plot, int n) {
        this.plot = plot;
        this.entrance = n;
        this.load();
        JPanel jPanel = new JPanel();
        MediaTracker mediaTracker = new MediaTracker(jPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.floor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/floor5.gif"));
        this.wall = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/wall2.gif"));
        this.stair = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/stair2.gif"));
        this.pots = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/pots.gif"));
        mediaTracker.addImage(this.floor, 0);
        mediaTracker.addImage(this.wall, 0);
        mediaTracker.addImage(this.stair, 0);
        mediaTracker.addImage(this.pots, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.X0 = 200;
        this.Y0 = 100;
    }

    private void load() {
        this.stateArr = this.plot.getInfo(2);
        this.items = new ArrayList();
        if ((Integer)this.stateArr.get(0) == 1) {
            this.items.add(new Item("Pots", "some fine pots"));
        }
    }

    public Populace getAltChars(World world) {
        return new Populace(world);
    }

    public Point getInitPos() {
        return new Point(25 + this.X0, 25 + this.Y0);
    }

    public int paintBack(Graphics graphics, DispPanel dispPanel, int n, int n2) {
        int n3 = 0;
        while (n3 < this.imageArr.length) {
            int n4 = n3 * 25 + this.Y0;
            int n5 = 0;
            while (n5 < this.imageArr[n3].length) {
                int n6 = n5 * 25 + this.X0;
                if (this.imageArr[n3][n5] == 2) {
                    graphics.drawImage(this.wall, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 1) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 3) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                    graphics.drawImage(this.stair, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 4) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                    if ((Integer)this.stateArr.get(0) == 1) {
                        graphics.drawImage(this.pots, n6, n4, dispPanel);
                    }
                }
                ++n5;
            }
            ++n3;
        }
        return 2;
    }

    public boolean isBackStatic() {
        return true;
    }

    public int isMoveOK(int n, int n2, int n3) {
        int n4 = (n2 - this.X0) / 25;
        int n5 = (n3 - this.Y0) / 25;
        if (n == 1) {
            --n4;
        } else if (n == 2) {
            --n5;
        } else if (n == 3) {
            ++n4;
        } else if (n == 4) {
            ++n5;
        }
        if (n5 < this.imageArr.length && n4 < this.imageArr[0].length && (this.imageArr[n5][n4] == 1 || this.imageArr[n5][n4] == 4 || this.imageArr[n5][n4] == 3)) {
            return 1;
        }
        return 2;
    }

    public int doMove(int n, int n2, int n3) {
        int n4 = (n3 - this.Y0) / 25;
        int n5 = (n2 - this.X0) / 25;
        if (this.imageArr[n4][n5] == 3) {
            return 4;
        }
        return 0;
    }

    public int doTransit(int n, int n2) {
        int n3 = (n2 - this.Y0) / 25;
        int n4 = (n - this.X0) / 25;
        if (this.imageArr[n3][n4] == 3) {
            return 1;
        }
        return 0;
    }

    public boolean isMoveOK(int n, int n2, int n3, ArrayList arrayList) {
        return n2 < this.imageArr.length && n < this.imageArr[0].length && (this.imageArr[n2][n] == 1 || this.imageArr[n2][n] == 0 || this.imageArr[n2][n] == 3 || this.imageArr[n2][n] == 4);
    }

    public void move(int n, int n2, int n3, int n4) {
    }

    public int openDoor(Hero hero) {
        return 0;
    }

    public String useItem(Hero hero, int n) {
        hero.useItem(n);
        return new String("Can't use that item.");
    }

    public Item getItem(Hero hero) {
        int n = (hero.getX() - this.X0) / 25;
        int n2 = (hero.getY() - this.Y0) / 25;
        Item item = null;
        if (this.imageArr[n2][n] == 4 && (Integer)this.stateArr.get(0) == 1) {
            item = (Item)this.items.remove(0);
            this.stateArr.set(0, new Integer(0));
        }
        return item;
    }

    public int command(int n, Hero hero) {
        return 0;
    }

    public boolean doKeyPress(int n, ArrayList arrayList, ArrayList arrayList2) {
        boolean bl = false;
        return bl;
    }

    public boolean isShowItems(Character character) {
        return false;
    }

    public boolean isQuestion(Hero hero, Character character, int n) {
        return false;
    }

    public String getDialogString(Hero hero, Character character, int n) {
        return "No one is there.";
    }

    public void incDialog(Character character) {
    }

    public void escDialog(Character character) {
    }

    public boolean isMoreDialog(Character character) {
        return false;
    }

    public void doYesDialog(Hero hero, int n) {
    }
}

