/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;

class IntroScreen {
    private JFrame frame;
    private JLabel statusBar;
    private Game game;
    private int step;
    private int choice;
    private int[] maxChoices = new int[]{0, 2, 0, 3};
    private final int MAX_NAME_LENGTH = 15;
    private String heroName;
    private int posX;
    private int posY;
    private char[][] nameChars = new char[][]{{'>', 'A', ' ', 'B', ' ', 'C', ' ', 'D', ' ', 'E', ' ', 'F', ' ', 'G', ' ', 'H', ' ', 'I', ' ', 'J', ' ', 'K'}, {' ', 'L', ' ', 'M', ' ', 'N', ' ', 'O', ' ', 'P', ' ', 'Q', ' ', 'R', ' ', 'S', ' ', 'T', ' ', 'U', ' ', 'V'}, {' ', 'W', ' ', 'X', ' ', 'Y', ' ', 'Z', ' ', '-', ' ', '\'', ' ', '!', ' ', '?', ' ', '(', ' ', ')', ' ', ' '}, {' ', 'a', ' ', 'b', ' ', 'c', ' ', 'd', ' ', 'e', ' ', 'f', ' ', 'g', ' ', 'h', ' ', 'i', ' ', 'j', ' ', 'k'}, {' ', 'l', ' ', 'm', ' ', 'n', ' ', 'o', ' ', 'p', ' ', 'q', ' ', 'r', ' ', 's', ' ', 't', ' ', 'u', ' ', 'v'}, {' ', 'w', ' ', 'x', ' ', 'y', ' ', 'z', ' ', ',', ' ', '.', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '\u00ab', ' ', '\u00b6'}};
    private Image image1;
    private Image image2;
    private Image image3;
    private int heroImageIndex;

    public IntroScreen(JFrame jFrame, JLabel jLabel, Game game) {
        this.frame = jFrame;
        this.statusBar = jLabel;
        this.game = game;
        this.step = 1;
        this.choice = 1;
        this.posX = 0;
        this.posY = 0;
        this.heroName = "";
    }

    public void paint(Graphics graphics) {
        if (this.step == 1) {
            this.drawStep1(graphics);
        } else if (this.step == 2) {
            this.drawStep2(graphics);
        } else if (this.step == 3) {
            this.drawStep3(graphics);
        } else if (this.step == 4) {
            this.drawStep4(graphics);
        } else if (this.step == 5) {
            this.drawStep5(graphics);
        } else if (this.step == 6) {
            this.drawStep6(graphics);
        }
    }

    private void drawStep1(Graphics graphics) {
        graphics.setFont(new Font("Verdana", 1, 48));
        graphics.setColor(new Color(255, 255, 0));
        graphics.drawString("RPG I", 280, 100);
        graphics.setFont(new Font("Verdana", 0, 18));
        graphics.setColor(new Color(255, 180, 0));
        graphics.drawString("-Press Enter-", 300, 150);
        graphics.setFont(new Font("Verdana", 0, 12));
        graphics.setColor(new Color(255, 0, 255));
        graphics.drawString("\u00a92002 LNR", 325, 200);
    }

    private void drawStep2(Graphics graphics) {
        graphics.setFont(new Font("Verdana", 1, 20));
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawString("Begin New Quest", 200, 100);
        graphics.drawString("Test the Game", 200, 150);
        if (this.choice == 1) {
            graphics.drawString("->", 150, 100);
        } else if (this.choice == 2) {
            graphics.drawString("->", 150, 150);
        }
    }

    private void drawStep3(Graphics graphics) {
        graphics.setFont(new Font("Monospaced", 1, 20));
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawString("Name: " + this.heroName, 200, 100);
        graphics.setFont(new Font("Monospaced", 0, 20));
        int n = 0;
        while (n < this.nameChars.length) {
            graphics.drawString(new String(this.nameChars[n]), 200, 150 + n * 20);
            ++n;
        }
    }

    private void drawStep4(Graphics graphics) {
        String string = this.heroName + ", how do you want others to see you?";
        graphics.setFont(new Font("Monospaced", 0, 14));
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawString(string, 100, 100);
        if (this.image1 == null) {
            MediaTracker mediaTracker = new MediaTracker(this.frame);
            JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
            this.image1 = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/chars/hero1 front.gif"));
            this.image2 = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/chars/hero2 front.gif"));
            this.image3 = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/chars/hero3 front.gif"));
            mediaTracker.addImage(this.image1, 0);
            mediaTracker.addImage(this.image2, 0);
            mediaTracker.addImage(this.image3, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        graphics.drawImage(this.image1, 150, 180, this.frame);
        graphics.drawImage(this.image2, 250, 180, this.frame);
        graphics.drawImage(this.image3, 350, 180, this.frame);
        graphics.setFont(new Font("Monospaced", 1, 14));
        if (this.choice == 1) {
            graphics.drawString("->", 120, 200);
        } else if (this.choice == 2) {
            graphics.drawString("->", 220, 200);
        } else if (this.choice == 3) {
            graphics.drawString("->", 320, 200);
        }
    }

    private void drawStep5(Graphics graphics) {
        String string = this.heroName + ", you live in a small village called Barren Road,";
        String string2 = "a village built by your great grandfather after escaping";
        String string3 = "the Peasant Riots in the corrupt city of New Orkins.";
        String string4 = "This year was a sad one for you. Your mother died in the";
        String string5 = "spring, leaving you as the sole worker in the steadily";
        String string6 = "failing family business. You are a ceramic artisan and you";
        String string7 = "aren't sure how much longer you can sustain yourself";
        String string8 = "making clay pots. You live in the house where you were";
        String string9 = "born. You have no family.";
        String string10 = "     ->";
        graphics.setFont(new Font("Verdana", 1, 16));
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawString(string, 50, 100);
        graphics.drawString(string2, 50, 120);
        graphics.drawString(string3, 50, 140);
        graphics.drawString(string4, 50, 160);
        graphics.drawString(string5, 50, 180);
        graphics.drawString(string6, 50, 200);
        graphics.drawString(string7, 50, 220);
        graphics.drawString(string8, 50, 240);
        graphics.drawString(string9, 50, 260);
        graphics.setFont(new Font("Monospaced", 1, 16));
        graphics.drawString(string10, 500, 300);
    }

    private void drawStep6(Graphics graphics) {
        String string = "You slowly open your eyes, awakened by a sliver of orange";
        String string2 = "sunlight on the wall by your bed and the chirps of birds";
        String string3 = "outside. Today is the day you go to the next village to";
        String string4 = "sell your pots and buy some much needed corn and wheat";
        String string5 = "to last the cold winter months.";
        String string6 = "You sit a while in bed, alone in your cold, empty house.";
        String string7 = "<-   ->";
        graphics.setFont(new Font("Verdana", 1, 16));
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawString(string, 50, 100);
        graphics.drawString(string2, 50, 120);
        graphics.drawString(string3, 50, 140);
        graphics.drawString(string4, 50, 160);
        graphics.drawString(string5, 50, 180);
        graphics.drawString(string6, 50, 200);
        graphics.setFont(new Font("Monospaced", 1, 16));
        graphics.drawString(string7, 500, 300);
    }

    public boolean handleKeyPress(int n) {
        if (n == 10) {
            if (this.step == 2 && this.choice == 2) {
                this.game.continueQuest();
            } else if (this.step == 3) {
                if (this.posX == 9 && this.posY == 5) {
                    if (this.heroName.length() > 0) {
                        this.heroName = this.heroName.substring(0, this.heroName.length() - 1);
                    }
                } else if (this.posX == 10 && this.posY == 5) {
                    if (this.heroName.length() > 0) {
                        ++this.step;
                        this.choice = 1;
                    }
                } else if (this.heroName.length() < 15) {
                    this.heroName = this.heroName + this.nameChars[this.posY][this.posX * 2 + 1];
                }
            } else if (this.step == 4) {
                this.heroImageIndex = this.choice;
                ++this.step;
            } else if (this.step == 5) {
                ++this.step;
            } else if (this.step == 6) {
                this.game.beginNewQuest(this.heroName, this.heroImageIndex);
            } else {
                ++this.step;
            }
            return true;
        }
        if (n == 40) {
            if (this.step == 2) {
                ++this.choice;
                this.choice = this.choice > this.maxChoices[this.step - 1] ? 1 : this.choice;
            } else if (this.step == 3) {
                this.nameChars[this.posY][this.posX * 2] = 32;
                ++this.posY;
                this.posY = this.posY > this.nameChars.length - 1 ? 0 : this.posY;
                this.nameChars[this.posY][this.posX * 2] = 62;
            }
            return true;
        }
        if (n == 38) {
            if (this.step == 2) {
                --this.choice;
                this.choice = this.choice < 1 ? this.maxChoices[this.step - 1] : this.choice;
            } else if (this.step == 3) {
                this.nameChars[this.posY][this.posX * 2] = 32;
                --this.posY;
                this.posY = this.posY < 0 ? this.nameChars.length - 1 : this.posY;
                this.nameChars[this.posY][this.posX * 2] = 62;
            }
            return true;
        }
        if (n == 37) {
            if (this.step == 3) {
                this.nameChars[this.posY][this.posX * 2] = 32;
                --this.posX;
                this.posX = this.posX < 0 ? (this.nameChars[0].length - 1) / 2 : this.posX;
                this.nameChars[this.posY][this.posX * 2] = 62;
            } else if (this.step == 4) {
                --this.choice;
                this.choice = this.choice < 1 ? this.maxChoices[this.step - 1] : this.choice;
            } else if (this.step == 6) {
                --this.step;
            }
            return true;
        }
        if (n == 39) {
            if (this.step == 3) {
                this.nameChars[this.posY][this.posX * 2] = 32;
                ++this.posX;
                this.posX = this.posX * 2 > this.nameChars[0].length - 1 ? 0 : this.posX;
                this.nameChars[this.posY][this.posX * 2] = 62;
            } else if (this.step == 4) {
                ++this.choice;
                this.choice = this.choice > this.maxChoices[this.step - 1] ? 1 : this.choice;
            } else if (this.step == 5) {
                ++this.step;
            } else if (this.step == 6) {
                this.game.beginNewQuest(this.heroName, this.heroImageIndex);
            }
            return true;
        }
        return false;
    }
}

