/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import javax.swing.JFrame;

class Painter {
    public static final int MAX_AREA_WIDTH = 28;
    public static final int MAX_AREA_HEIGHT = 16;
    public static final int BLOCK_SIZE = 25;
    public static final int BACK_NOT_STATIC = 1;
    public static final int BACK_STATIC = 2;
    private JFrame frame;
    private DispPanel dispPanel;
    private ControlPanel ctrlPanel;
    private Dialog dialog;
    private Game game;
    private World world;
    private Hero hero;
    private Populace altChars;
    private IntroScreen introscreen;
    private int dx;
    private int dy;
    private int direction;

    public Painter(JFrame jFrame, DispPanel dispPanel, ControlPanel controlPanel, Game game, World world, Dialog dialog) {
        this.frame = jFrame;
        this.game = game;
        this.world = world;
        this.dispPanel = dispPanel;
        this.ctrlPanel = controlPanel;
        this.dialog = dialog;
        this.dispPanel.setPainter(this);
        this.dx = 0;
        this.dy = 0;
    }

    public void init(Hero hero) {
        this.hero = hero;
        this.dx = 0;
        this.dy = 0;
    }

    public void init(Populace populace) {
        this.altChars = populace;
    }

    public void setIntroScreen(IntroScreen introScreen) {
        this.introscreen = introScreen;
    }

    public void doCompleteRepaint() {
        this.dispPanel.repaint();
        this.ctrlPanel.repaint();
    }

    public void doRepaint() {
        this.dispPanel.repaint();
    }

    public void doRepaint(int n, int n2) {
        this.dx = n;
        this.dy = n2;
        this.dispPanel.repaint();
    }

    public int getDirection() {
        return this.direction;
    }

    public void paint(Graphics graphics) {
        if (this.game.getMode() == 2) {
            if (this.introscreen != null) {
                this.introscreen.paint(graphics);
            }
        } else {
            int n = this.world.paintBack(graphics, this.dispPanel, this.dx, this.dy);
            if (n == 2) {
                this.altChars.paint(graphics, this.dispPanel, 0, 0);
            } else {
                this.altChars.paint(graphics, this.dispPanel, -this.dx, -this.dy);
            }
            if (n == 2) {
                this.hero.paint(graphics, this.dispPanel, this.dx, this.dy);
            } else {
                this.hero.paint(graphics, this.dispPanel, 0, 0);
            }
            if (this.game.getMode() == 7) {
                this.dialog.paintStatus(this.hero, graphics);
            } else if (this.game.getMode() == 5) {
                this.dialog.paintItems(this.hero, graphics);
            } else if (this.game.getMode() == 6) {
                this.dialog.paintDoorError(this.game.getStatus(), graphics);
            }
        }
    }
}

